package com.biz.crm.costtypecategories.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.PageUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesRangeEntity;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动大类范围表;接口实现
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TmpCostTypeCategoriesRangeServiceExpandImpl")
public class TpmCostTypeCategoriesRangeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmCostTypeCategoriesRangeMapper, TpmCostTypeCategoriesRangeEntity> implements ITpmCostTypeCategoriesRangeService {

    @Resource
    private TpmCostTypeCategoriesRangeMapper tpmCostTypeCategoriesRangeMapper;

    /**
     * 列表
     * @param tpmCostTypeCategoriesRangeReqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmCostTypeCategoriesRangeRespVo> findList(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo){
        Page<TpmCostTypeCategoriesRangeRespVo> page = PageUtil.buildPage(tpmCostTypeCategoriesRangeReqVo.getPageNum(), tpmCostTypeCategoriesRangeReqVo.getPageSize());
        List<TpmCostTypeCategoriesRangeRespVo> list = tpmCostTypeCategoriesRangeMapper.findList(page, tpmCostTypeCategoriesRangeReqVo);
        return PageResult.<TpmCostTypeCategoriesRangeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param tpmCostTypeCategoriesRangeReqVo
     * @return tmpCostTypeCategoriesRangeRespVo
     */
    @Override
    @CrmLog
    public TpmCostTypeCategoriesRangeRespVo query(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo){
        return null;
    }

    /**
     * 新增
     * @param tpmCostTypeCategoriesRangeReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo){
        TpmCostTypeCategoriesRangeEntity entity = CrmBeanUtil.copy(tpmCostTypeCategoriesRangeReqVo, TpmCostTypeCategoriesRangeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param tpmCostTypeCategoriesRangeReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo){
        TpmCostTypeCategoriesRangeEntity entity = this.getById(tpmCostTypeCategoriesRangeReqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids){
        List<TpmCostTypeCategoriesRangeEntity> tmpCostTypeCategoriesRangeEntities = tpmCostTypeCategoriesRangeMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tmpCostTypeCategoriesRangeEntities)){
            tmpCostTypeCategoriesRangeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tmpCostTypeCategoriesRangeEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmCostTypeCategoriesRangeEntity> tmpCostTypeCategoriesRangeEntities = tpmCostTypeCategoriesRangeMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tmpCostTypeCategoriesRangeEntities)){
            tmpCostTypeCategoriesRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tmpCostTypeCategoriesRangeEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmCostTypeCategoriesRangeEntity> tmpCostTypeCategoriesRangeEntities = tpmCostTypeCategoriesRangeMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tmpCostTypeCategoriesRangeEntities)){
                tmpCostTypeCategoriesRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tmpCostTypeCategoriesRangeEntities);
    }
}
