package com.biz.crm.costtypefine.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 活动细类 实体类
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_cost_type_fine")
@CrmTable(name = "tpm_cost_type_fine",tableNote = "TPM-活动细类")
public class TpmCostTypeFineEntity extends CrmExtEntity<TpmCostTypeFineEntity> {

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;

    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 60,note = "活动细类名称")
    private String fineName;

    /**
     * ERP会计科目编码
     */
    @CrmColumn(name = "finance_subjects_erp_code", length = 32,note = "ERP会计科目编码")
    private String financeSubjectsErpCode;

    /**
     * ERP会计科目名称
     */
    @CrmColumn(name = "finance_subjects_erp_name", length = 60,note = "ERP会计科目名称")
    private String financeSubjectsErpName;

    /**
     * 活动发布需求(字典)
     */
    @CrmColumn(name = "activity_release_need", length = 32,note = "活动发布需求(字典)")
    private String activityReleaseNeed;

    /**
     * 活动方式(字典)
     */
    @CrmColumn(name = "activity_type", length = 32,note = "活动方式(字典)")
    private String activityType;

    /**
     * 费用是否分摊到产品(Y/N)
     */
    @CrmColumn(name = "is_share_to_product", length = 10,note = "费用是否分摊到产品(Y/N)")
    private String isShareToProduct;
    /**
     * 支付方式(字典)
     */
    @CrmColumn(name = "pay_type_list", length = 32,note = "付方式(字典)")
    private String payTypeList;

    /**
     * 是否核销
     */
    @CrmColumn(name = "is_audit", length = 10,note = "是否核销")
    private String isAudit;

    /**
     * 是否自动核销
     */
    @CrmColumn(name = "is_auto_audit", length = 10,note = "是否自动核销")
    private String isAutoAudit;

    /**
     * 允许多次核销
     */
    @CrmColumn(name = "is_allow_repeat_audit", length = 32,note = "允许多次核销")
    private String isAllowRepeatAudit;

    /**
     * 超额核销比例
     */
    @CrmColumn(name = "extra_audit_ratio",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "超额核销比例")
    private BigDecimal extraAuditRatio;

    /**
     * 核销有效期(月)
     */
    @CrmColumn(name = "audit_validity",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "核销有效期(月)")
    private Integer auditValidity;

    /**
     * 是否推送SFA
     */
    @CrmColumn(name = "is_send_sfa", length = 10,note = "是否推送SFA")
    private String isSendSfa;

    /**
     * 是否推送AI
     */
    @CrmColumn(name = "is_send_ai", length = 10,note = "是否推送AI")
    private String isSendAi;

    /**
     * 采集要求(集合的json)
     */
    @CrmColumn(name = "collect_require_list", length = 200,note = "采集要求(集合的json)")
    private String collectRequireList;

    /**
     * 核销资料要求(集合的json)
     */
    @CrmColumn(name = "audit_require_list", length = 200,note = "核销资料要求(集合的json)")
    private String auditRequireList;

    /**
     * 活动明细表单
     */
    @CrmColumn(name = "cost_form_code", length = 32,note = "活动明细表单")
    private String costFormCode;

    /**
     * 活动核销表单
     */
    @CrmColumn(name = "audit_form_code", length = 32,note = "活动核销表单")
    private String auditFormCode;

    /**
     * 适用层级(字典)
     */
    @CrmColumn(name = "cost_level", length = 32,note = "适用层级(字典)")
    private String costLevel;

    /**
     * 适用组织编码
     */
    @CrmColumn(name = "cost_org_code", length = 32,note = "适用组织编码")
    private String costOrgCode;

    /**
     * 适用组织名称
     */
    @CrmColumn(name = "cost_org_name", length = 60,note = "适用组织名称")
    private String costOrgName;

    /**
     * 是否跨组织占用预算(Y/N)
     */
    @CrmColumn(name = "is_span_org_budget", length = 10,note = "是否跨组织占用预算(Y/N)")
    private String isSpanOrgBudget;

    /**
     * 是否审核活动明细(Y/N)
     */
    @CrmColumn(name = "is_review_activity_details", length = 10,note = "是否审核活动明细(Y/N)")
    private String isReviewActivityDetails;

    /**
     * 是否进行督导(Y/N)
     */
    @CrmColumn(name = "is_supervise", length = 10,note = "是否进行督导(Y/N)")
    private String isSupervise;

    /**
     * 是否需要采集资料(Y/N)
     */
    @CrmColumn(name = "is_need_collect_data", length = 10,note = "是否需要采集资料(Y/N)")
    private String isNeedCollectData;

    /**
     * 是否需要核销资料(Y/N)
     */
    @CrmColumn(name = "is_need_audit_data", length = 10,note = "是否需要核销资料(Y/N)")
    private String isNeedAuditData;


    /**
     * 是否采集活动数据(Y/N)
     */
    @CrmColumn(name = "is_collect_act_data", length = 10,note = "是否采集活动数据(Y/N)")
    private String isCollectActData;

    /**
     * 是否采集分销订单(Y/N)
     */
    @CrmColumn(name = "is_collect_distribution_order", length = 10,note = "是否采集分销订单(Y/N)")
    private String isCollectDistributionOrder;
    /**
     * 是否签署陈列协议(Y/N)
     */
    @CrmColumn(name = "is_sign_display_agreement", length = 10,note = "是否签署陈列协议(Y/N)")
    private String isSignDisplayAgreement;

    /**
     * 兑付方式(数据字典:payment_method,现金兑付,货品兑付)
     */
    @CrmColumn(name = "payment_method", length = 64,note = "兑付方式(数据字典:payment_method,现金兑付,货品兑付)")
    private String paymentMethod;

    /**
     * 是否控制活动费用(Y/N)
     */
    @CrmColumn(name = "is_control_act_fee", length = 10,note = "是否控制活动费用(Y/N)")
    private String isControlActFee;

}
