package com.biz.crm.costtypefine.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileConvertReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;

import java.util.List;

/**
 * 活动细类 接口
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
public interface ITpmCostTypeFineService extends IService<TpmCostTypeFineEntity> {

    /**
     * 列表
     * @param tpmCostTypeFineReqVo
     * @return PageResult<TpmCostTypeFineRespVo>
     */
    PageResult<TpmCostTypeFineRespVo> findList(TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 查询
     * @param id
     * @return TpmCostTypeFineRespVo
     */
    TpmCostTypeFineRespVo query(String id);

    /**
     * 新增
     * @param tpmCostTypeFineReqVo
     * @return
     */
    void save(TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 更新
     * @param tpmCostTypeFineReqVo
     * @return
     */
    void update(TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     *  核销申请中核销资料
     * @param reqVo
     * @return
     */
    List<TpmCostTypeFineRespVo> costTypeFineListByFineCode(TpmAuditFileConvertReqVo reqVo);

    /**
     * 活动细类,根据细类编码查询细类关联的活动大类集合
     * @param reqVo
     * @return
     */
    PageResult<TpmCostTypeCategoriesRespVo> findCategoriesByFineCode(TpmCostTypeFineReqVo reqVo);

    /**
     * @Description 根据细类编码查询  上账科目名称
     * @Date 2020/10/30
     * @Param [tpmCostTypeFineReqVo]
     * @return java.util.List<com.biz.crm.common.DictItemVo>
     **/
    List<TpmCostTypeFineRespVo> financeSubjectsErpCodeByFindCode(TpmAccountInvoiceReqVo reqVo);
    
}

