package com.biz.crm.costtypefine.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesRangeEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.costtypecategories.service.impl.CostTypeCategoriesServiceHelper;
import com.biz.crm.costtypefine.mapper.TpmActCollectFieldFineMapper;
import com.biz.crm.costtypefine.model.TpmActCollectFieldFineEntity;
import com.biz.crm.costtypefine.service.ITpmActCollectFieldFineService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExamplePictureMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExamplePictureEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileConvertReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesFineRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmActCollectFieldFineReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmActCollectFieldFineRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 活动细类 接口实现
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmCostTypeFineServiceExpandImpl")
public class TpmCostTypeFineServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmCostTypeFineMapper, TpmCostTypeFineEntity> implements ITpmCostTypeFineService {

    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private CostTypeFineServiceHelper serviceHelper;
    @Resource
    private TpmAuditCollectExampleMapper tpmAuditCollectExampleMapper;
    @Resource
    private TpmAuditCollectExamplePictureMapper tpmAuditCollectExamplePictureMapper;
    @Resource
    private ITpmActCollectFieldFineService iTpmActCollectFieldFineService;
    @Resource
    private TpmAccountDetailMapper accountDetailMapper;

    @Resource
    private TpmActCollectFieldFineMapper fieldFineMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;
    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper costTypeCategoriesFineMapper;


    /**
     * 列表
     * @param tpmCostTypeFineReqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmCostTypeFineRespVo> findList(TpmCostTypeFineReqVo tpmCostTypeFineReqVo){
        Page<TpmCostTypeFineRespVo> page = PageUtil.buildPage(tpmCostTypeFineReqVo.getPageNum(), tpmCostTypeFineReqVo.getPageSize());
        tpmCostTypeFineReqVo.setSelectedCodeList(serviceHelper.dealSelectedCodeList(tpmCostTypeFineReqVo.getSelectedCode(),tpmCostTypeFineReqVo.getSelectedCodeList()));
        List<TpmCostTypeFineRespVo> list = tpmCostTypeFineMapper.findList(page, tpmCostTypeFineReqVo);
        serviceHelper.convertListDate(list);
        return PageResult.<TpmCostTypeFineRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tpmCostTypeFineRespVo
     */
    @Override
    @CrmLog
        public TpmCostTypeFineRespVo query(String id){
        AssertUtils.isNotEmpty(id, "id不能为空");
        TpmCostTypeFineReqVo tpmCostTypeFineReqVo = new TpmCostTypeFineReqVo();
        tpmCostTypeFineReqVo.setId(id);
        List<TpmCostTypeFineRespVo> list = this.findList(tpmCostTypeFineReqVo).getData();
        if(CollectionUtils.isEmpty(list)){
            return new TpmCostTypeFineRespVo();
        }
        TpmCostTypeFineRespVo respVo = list.get(0);

        //查询范围信息
        TpmCostTypeCategoriesRangeReqVo rangeReqVo = new TpmCostTypeCategoriesRangeReqVo();
        rangeReqVo.setPageSize(-1);
        rangeReqVo.setCategoriesCode(respVo.getFineCode());
        List<TpmCostTypeCategoriesRangeRespVo> rangeVos = rangeService.findList(rangeReqVo).getData();
        //把范围信息按照组织,组织类型,包含非包含做拆分
        Map<String, List<TpmCostTypeCategoriesRangeRespVo>> map = rangeVos.stream().collect(Collectors.groupingBy(o -> o.getRangeType() + o.getIsContain()));
        map.keySet().forEach(o -> {
            List<TpmCostTypeCategoriesRangeRespVo> vos = map.get(o);
            if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG + TpmGlobalDictConstants.CONTAIN, o)) {
                //组织包含
                respVo.setContainOrgRangeVos(vos);
            } else if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG + TpmGlobalDictConstants.NON_CONTAIN, o)) {
                //组织非包含
                respVo.setNonContainOrgRangeVos(vos);
            } else if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG_TYPE + TpmGlobalDictConstants.CONTAIN, o)) {
                //组织类型包含
                respVo.setContainOrgTypeRangeVos(vos);
            } else if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG_TYPE + TpmGlobalDictConstants.NON_CONTAIN, o)) {
                respVo.setNonContainOrgTypeRangeVos(vos);
            } else {
                throw new BusinessException("活动细类" + respVo.getFineCode() + "范围信息数据异常");
            }
        });

        //查询关联大类数据
        TpmCostTypeCategoriesFineReqVo categoriesReqVo = new TpmCostTypeCategoriesFineReqVo();
        categoriesReqVo.setPageSize(-1);
        categoriesReqVo.setFineCode(respVo.getFineCode());
        List<TpmCostTypeCategoriesFineRespVo> categoriesVos = fineService.findList(categoriesReqVo).getData();
        respVo.setTpmCostTypeCategoriesFineRespVo(categoriesVos);

        //组装采集需求和核销资料要求的名称
        if(StringUtils.isNotEmpty(respVo.getCollectRequireList())){
            List<TpmAuditCollectExampleRespVo> collectRequires = serviceHelper.getExamples(respVo.getCollectRequireList());
            respVo.setCollectRequires(collectRequires);
        }
        if(StringUtils.isNotEmpty(respVo.getAuditRequireList())){
            List<TpmAuditCollectExampleRespVo> auditRequires = serviceHelper.getExamples(respVo.getAuditRequireList());
            respVo.setAuditRequires(auditRequires);
        }
        //支付方式集合
        if(StringUtils.isNotEmpty(respVo.getPayTypeList())){
            List<DictItemVo> payTypes = serviceHelper.getPayTypes(respVo.getPayTypeList());
            respVo.setPayTypes(payTypes);
        }
        List<TpmActCollectFieldFineEntity> fieldFineEntities= iTpmActCollectFieldFineService.lambdaQuery().eq(TpmActCollectFieldFineEntity::getFineCode, respVo.getFineCode()).select(
                TpmActCollectFieldFineEntity::getFieldCode,TpmActCollectFieldFineEntity::getFieldName).list();
        if(CollectionUtils.isNotEmpty(fieldFineEntities)){
            respVo.setCollectFieldList(CrmBeanUtil.copyList(fieldFineEntities, TpmActCollectFieldFineRespVo.class));
        }
        //转义是否核销
        respVo.setIsAuditEsc(GlobalWhetherEnum.getDesByCode(respVo.getIsAudit()));
        //转义是否推送SFA
        respVo.setIsSendSfaEsc(GlobalWhetherEnum.getDesByCode(respVo.getIsSendSfa()));
        //转义是否审核活动细明
        respVo.setIsReviewActivityDetailsEsc(GlobalWhetherEnum.getDesByCode(respVo.getIsReviewActivityDetails()));
        //转义是否跨组织占用预算
        respVo.setIsSpanOrgBudgetEsc(GlobalWhetherEnum.getDesByCode(respVo.getIsSpanOrgBudget()));
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmCostTypeFineReqVo reqVo){
        serviceHelper.saveCheck(reqVo);
        TpmCostTypeFineEntity entity = CrmBeanUtil.copy(reqVo,TpmCostTypeFineEntity.class);
        this.save(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmCostTypeFineRespVo newData = CrmBeanUtil.copy(entity, TpmCostTypeFineRespVo.class);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getFineCode(),newData);

        if(CollectionUtils.isNotEmpty(reqVo.getCollectFieldList())){
            List<TpmActCollectFieldFineEntity> fieldFineEntities = reqVo.getCollectFieldList().stream().map(o -> {
                TpmActCollectFieldFineEntity fieldFineEntity = new TpmActCollectFieldFineEntity();
                CrmBeanUtil.copyProperties(o,fieldFineEntity);
                fieldFineEntity.setFineCode(entity.getFineCode());
                return fieldFineEntity;
            }).collect(Collectors.toList());
            iTpmActCollectFieldFineService.saveOrUpdateBatch(fieldFineEntities);
        }
        //保存关联细类数据、范围信息数据
        reqVo.setFineCode(entity.getFineCode());
        if(StringUtils.isNotEmpty(reqVo.getTpmProjectName()) && TpmProjectNameEnum.LIQUEUR_TPM.getCode().equals(reqVo.getTpmProjectName())){
            serviceHelper.saveCategoriesAssociatedData(reqVo);
        }

    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmCostTypeFineReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())){
            throw new BusinessException("数据主键不能为空");
        }
        TpmCostTypeFineEntity entity = this.getById(reqVo.getId());
        if(Objects.isNull(entity)){
            throw new BusinessException(CostTypeFineException.DATA_NOT_EXIST);
        }
        reqVo.setFineCode(entity.getFineCode());
        serviceHelper.saveCheck(reqVo);
        //日志老数据
        TpmCostTypeFineRespVo oldData = CrmBeanUtil.copy(entity, TpmCostTypeFineRespVo.class);
        CrmBeanUtil.copyProperties(reqVo,entity);
        this.updateById(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmCostTypeFineRespVo newData = CrmBeanUtil.copy(entity, TpmCostTypeFineRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getFineCode(),oldData,newData);

        LambdaQueryWrapper<TpmActCollectFieldFineEntity> wrapper = Wrappers.<TpmActCollectFieldFineEntity>lambdaQuery().eq(TpmActCollectFieldFineEntity::getFineCode, entity.getFineCode());
        List<TpmActCollectFieldFineReqVo> collectFieldList = reqVo.getCollectFieldList();
        if(CollectionUtils.isNotEmpty(collectFieldList)){
            List<String> ids = collectFieldList.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmActCollectFieldFineReqVo::getId).collect(Collectors.toList());
            wrapper.notIn(CollectionUtils.isNotEmpty(ids),TpmActCollectFieldFineEntity::getId,ids);
            fieldFineMapper.delete(wrapper);
            List<TpmActCollectFieldFineEntity> fieldFineEntities = collectFieldList.stream().map(o -> {
                TpmActCollectFieldFineEntity fieldFineEntity = new TpmActCollectFieldFineEntity();
                CrmBeanUtil.copyProperties(o, fieldFineEntity);
                fieldFineEntity.setFineCode(entity.getFineCode());
                return fieldFineEntity;
            }).collect(Collectors.toList());
            iTpmActCollectFieldFineService.saveOrUpdateBatch(fieldFineEntities);
        }else {
            fieldFineMapper.delete(wrapper);
        }
        //更新细类大类关联表、范围信息数据
        if(StringUtils.isNotEmpty(reqVo.getTpmProjectName()) && TpmProjectNameEnum.LIQUEUR_TPM.getCode().equals(reqVo.getTpmProjectName())){
            serviceHelper.saveCategoriesAssociatedData(reqVo);
        }
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids){
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        //日志老数据
        PageResult<TpmCostTypeFineRespVo> oldDataList = this.findList(new TpmCostTypeFineReqVo().setIds(ids));
        List<TpmCostTypeFineRespVo> list = oldDataList.getData();
        if(CollectionUtils.isNotEmpty(list)){
            tpmCostTypeFineMapper.deleteBatchIds(ids);
            List<String> codes = list.stream().map(TpmCostTypeFineRespVo::getFineCode).collect(Collectors.toList());
            fieldFineMapper.delete(Wrappers.lambdaQuery(TpmActCollectFieldFineEntity.class).in(TpmActCollectFieldFineEntity::getFineCode,codes));
            fieldFineMapper.delete(Wrappers.lambdaQuery(TpmActCollectFieldFineEntity.class).in(TpmActCollectFieldFineEntity::getFineCode,codes));
            rangeMapper.delete(Wrappers.lambdaQuery(TpmCostTypeCategoriesRangeEntity.class).in(TpmCostTypeCategoriesRangeEntity::getCategoriesCode,codes));
            costTypeCategoriesFineMapper.delete(Wrappers.lambdaQuery(TpmCostTypeCategoriesFineEntity.class).in(TpmCostTypeCategoriesFineEntity::getFineCode,codes));
            //日志
            Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            oldDataList.getData().stream().forEach(o->{
                crmLogSendUtil.sendForDel(menuCodeObj.toString(),o.getId(),o.getFineCode(),o);
            });
        }
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids){
        //设置状态为启用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmCostTypeFineEntity> entities = tpmCostTypeFineMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmCostTypeFineRespVo> oldDataList = CrmBeanUtil.copyList(entities, TpmCostTypeFineRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmCostTypeFineRespVo> newDataList = CrmBeanUtil.copyList(entities, TpmCostTypeFineRespVo.class);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getFineCode(),oldDataList.get(i),newDataList.get(i));
        }

    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmCostTypeFineEntity> entities = tpmCostTypeFineMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmCostTypeFineRespVo> oldDataList = CrmBeanUtil.copyList(entities, TpmCostTypeFineRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        //日志
        List<TpmCostTypeFineRespVo> newDataList = CrmBeanUtil.copyList(entities, TpmCostTypeFineRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getFineCode(),oldDataList.get(i),newDataList.get(i));
        }
    }

    /**
     *  核销申请中核销资料
     * @param reqVo
     * @return
     */
    @Override
    public List<TpmCostTypeFineRespVo> costTypeFineListByFineCode(TpmAuditFileConvertReqVo reqVo) {

        AssertUtils.isNotEmpty(reqVo.getFineCodeList(),"细类编码集合不能为空");
        QueryWrapper<TpmCostTypeFineEntity> wrapper = new QueryWrapper<>();
        wrapper.in("fine_code", Sets.newHashSet(reqVo.getFineCodeList()));
        List<TpmCostTypeFineEntity>  tpmCostTypeFineEntities = tpmCostTypeFineMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(tpmCostTypeFineEntities)) {
            return Lists.newArrayList();
        }
        List<TpmCostTypeFineRespVo> tpmCostTypeFineRespVos = CrmBeanUtil.copyList(tpmCostTypeFineEntities, TpmCostTypeFineRespVo.class);
        //设置核销资料要求
        List<String> auditRequireList = tpmCostTypeFineRespVos.stream().filter(o->StringUtils.isNotEmpty(o.getAuditRequireList())).map(TpmCostTypeFineRespVo::getAuditRequireList).collect(Collectors.toList());
        List<String> collectRequireList = tpmCostTypeFineRespVos.stream().filter(o->StringUtils.isNotEmpty(o.getCollectRequireList())).map(TpmCostTypeFineRespVo::getCollectRequireList).collect(Collectors.toList());
        List<String> codes =new ArrayList<>();
        auditRequireList.forEach(listJson -> {
            if(StringUtils.isNotEmpty(listJson)){
                codes.addAll(JSON.parseArray(listJson, String.class));
            }
        });
        collectRequireList.forEach(listJson -> {
            if(StringUtils.isNotEmpty(listJson)){
                codes.addAll(JSON.parseArray(listJson, String.class));
            }
        });
        List<String> auditRequireCodes = codes.stream().distinct().collect(Collectors.toList());
        Map<String, TpmAuditCollectExampleRespVo> exampleMap = getExampleMap(auditRequireCodes);

        //如果传入的核销资料集合不为空,就把对应的资料分组后放在核销采集要求里面,前端做不出来,所以才这样搞的
        Map<String,List<TpmAuditFileReqVo>> fileMap = Maps.newHashMap();
        if(CollectionUtils.isNotEmpty(reqVo.getAuditFileReqVos())){
            fileMap = reqVo.getAuditFileReqVos().stream().filter(o->StringUtils.isNotEmpty(o.getFineCode())&&StringUtils.isNotEmpty(o.getExampleCode())).collect(Collectors.groupingBy(o -> o.getFineCode() + o.getExampleCode()));
        }
        for (TpmCostTypeFineRespVo tpmCostTypeFineRespVo : tpmCostTypeFineRespVos) {
            if(StringUtils.isNotEmpty(tpmCostTypeFineRespVo.getAuditRequireList())){
                List<String> auditRequires = JSON.parseArray(tpmCostTypeFineRespVo.getAuditRequireList(), String.class);
                List<TpmAuditCollectExampleRespVo> collectExampleRespVos= new ArrayList<>();
                for (String exampleCode : auditRequires) {
                    TpmAuditCollectExampleRespVo exampleRespVo = exampleMap.get(exampleCode);
                    TpmAuditCollectExampleRespVo copy = CrmBeanUtil.copy(exampleRespVo, TpmAuditCollectExampleRespVo.class);
                    if(Objects.nonNull(exampleRespVo)){
                        if(MapUtils.isNotEmpty(fileMap)){
                            List<TpmAuditFileReqVo> tpmAuditFileReqVos = fileMap.get(tpmCostTypeFineRespVo.getFineCode() + exampleRespVo.getExampleCode());
                            copy.setAuditFileReqVos(tpmAuditFileReqVos);
                        }
                        collectExampleRespVos.add(copy);
                    }
                }
                tpmCostTypeFineRespVo.setAuditRequires(collectExampleRespVos);
            }
            if(StringUtils.isNotEmpty(tpmCostTypeFineRespVo.getCollectRequireList())){
                List<String> collectRequires = JSON.parseArray(tpmCostTypeFineRespVo.getCollectRequireList(), String.class);
                List<TpmAuditCollectExampleRespVo> collectExampleRespVos= new ArrayList<>();
                for (String exampleCode : collectRequires) {
                    TpmAuditCollectExampleRespVo exampleRespVo = exampleMap.get(exampleCode);
                    TpmAuditCollectExampleRespVo copy = CrmBeanUtil.copy(exampleRespVo, TpmAuditCollectExampleRespVo.class);
                    if(Objects.nonNull(exampleRespVo)){
                        collectExampleRespVos.add(copy);
                    }
                }
                tpmCostTypeFineRespVo.setCollectRequires(collectExampleRespVos);
            }
        }
        return tpmCostTypeFineRespVos;
    }

    /**
     * 获取核销采集示例数据
     * @param auditRequireCodes
     * @return
     */
    private Map<String, TpmAuditCollectExampleRespVo>  getExampleMap(List<String> auditRequireCodes ){
        if(CollectionUtils.isNotEmpty(auditRequireCodes)){
            LambdaQueryWrapper<TpmAuditCollectExampleEntity> queryWrapper =
                    new LambdaQueryWrapper<TpmAuditCollectExampleEntity>().in(TpmAuditCollectExampleEntity::getExampleCode,auditRequireCodes);

            LambdaQueryWrapper<TpmAuditCollectExamplePictureEntity> pictureQueryWrapper =
                    new LambdaQueryWrapper<TpmAuditCollectExamplePictureEntity>().in(TpmAuditCollectExamplePictureEntity::getExampleCode,auditRequireCodes);

            List<TpmAuditCollectExampleEntity> exampleEntities = tpmAuditCollectExampleMapper.selectList(queryWrapper);

            List<TpmAuditCollectExamplePictureEntity> examplePictureEntities = tpmAuditCollectExamplePictureMapper.selectList(pictureQueryWrapper);
            Map<String, TpmAuditCollectExampleRespVo> nameMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(exampleEntities)){
                Map<String, List<TpmAuditCollectExampleEntity>> collect = exampleEntities.stream()
                        .collect(Collectors.groupingBy(TpmAuditCollectExampleEntity::getExampleCode));
                for (Map.Entry<String, List<TpmAuditCollectExampleEntity>> stringListEntry : collect.entrySet()) {
                    TpmAuditCollectExampleEntity tpmAuditCollectExampleEntity = stringListEntry.getValue().get(0);
                    TpmAuditCollectExampleRespVo collectExampleRespVo = CrmBeanUtil.copy(tpmAuditCollectExampleEntity, TpmAuditCollectExampleRespVo.class);
                    if(CollectionUtils.isNotEmpty(examplePictureEntities)){
                        Map<String, List<TpmAuditCollectExamplePictureEntity>> pictureMap = examplePictureEntities.stream()
                                .collect(Collectors.groupingBy(TpmAuditCollectExamplePictureEntity::getExampleCode));
                        for (Map.Entry<String, List<TpmAuditCollectExamplePictureEntity>> listEntry : pictureMap.entrySet()) {
                            if(StringUtils.equals(stringListEntry.getKey(),listEntry.getKey())){
                                collectExampleRespVo.setPictureRespVos(CrmBeanUtil.copyList(listEntry.getValue(),TpmAuditCollectExamplePictureRespVo.class));
                            }
                        }
                    }
                    nameMap.put(stringListEntry.getKey(),collectExampleRespVo);
                }
            }
            return nameMap;
        }
        return Maps.newHashMap();
    }

    /**
     * 活动细类,根据细类编码查询细类关联的活动大类集合
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmCostTypeCategoriesRespVo> findCategoriesByFineCode(TpmCostTypeFineReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getFineCode(),"活动细类编码不能为空");
        Page<TpmCostTypeCategoriesRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmCostTypeCategoriesRespVo> list=tpmCostTypeFineMapper.findCategoriesByFineCode(page,reqVo);
        return PageResult.<TpmCostTypeCategoriesRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * @Description 费用上账根据细类编码集合或者上账单号集合查询上账科目集合
     * @Date 2020/10/30
     * @Param [tpmCostTypeFineReqVo]
     * @return java.util.List<com.biz.crm.common.DictItemVo>
     **/
    @Override
    public List<TpmCostTypeFineRespVo> financeSubjectsErpCodeByFindCode(TpmAccountInvoiceReqVo reqVo) {
        List<String> fineCodeList = reqVo.getFineCodeList();
//        if(CollectionUtils.isNotEmpty(reqVo.getAccountCodeList())){
//            //通过上账单号集合查询细类编码集合
//            List<TpmAccountDetailEntity> tpmAccountDetailEntities = accountDetailMapper.selectList(Wrappers.lambdaQuery(TpmAccountDetailEntity.class).in(TpmAccountDetailEntity::getAccountCode, reqVo.getAccountCodeList()));
//            if(CollectionUtils.isNotEmpty(tpmAccountDetailEntities)){
//                List<String> list = tpmAccountDetailEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getFineCode())).map(TpmAccountDetailEntity::getFineCode).collect(Collectors.toList());
//                if(CollectionUtils.isEmpty(fineCodeList)){
//                    fineCodeList=Lists.newArrayList();
//                }
//                fineCodeList.addAll(list);
//            }
//        }
        if(CollectionUtils.isEmpty(fineCodeList)){
            return Lists.newArrayList();
        }
        Set<String> collect = fineCodeList.stream().collect(Collectors.toSet());
        List<TpmCostTypeFineEntity> tpmCostTypeFineEntities = tpmCostTypeFineMapper.selectList(Wrappers.<TpmCostTypeFineEntity>lambdaQuery()
                .in(TpmCostTypeFineEntity::getFineCode, collect));
        if(CollectionUtils.isNotEmpty(tpmCostTypeFineEntities)){
            List<TpmCostTypeFineRespVo> collect1 = tpmCostTypeFineEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getFinanceSubjectsErpCode()) && StringUtils.isNotEmpty(o.getFinanceSubjectsErpName())).map(o -> {
                TpmCostTypeFineRespVo vo = new TpmCostTypeFineRespVo();
                vo.setFinanceSubjectsErpCode(o.getFinanceSubjectsErpCode());
                vo.setFinanceSubjectsErpName(o.getFinanceSubjectsErpName());
                vo.setFineName(o.getFinanceSubjectsErpCode() + o.getFinanceSubjectsErpName());
                return vo;
            }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(TpmCostTypeFineRespVo::getFineName))), ArrayList::new));
            return collect1;
        }
        return Lists.newArrayList();
    }
}
