package com.biz.crm.feebudget.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 费用预算管控维度表 
 *
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */
@Slf4j
@RestController
@RequestMapping("/tpmFeeBudgetControlController")
@Api(tags = "费用预算管控维度表 ")
public class TpmFeeBudgetControlController {
    @Autowired
    private ITpmFeeBudgetControlService tpmFeeBudgetControlService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmFeeBudgetControlRespVo>> list(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
        PageResult<TpmFeeBudgetControlRespVo> result=tpmFeeBudgetControlService.findList(tpmFeeBudgetControlReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmFeeBudgetControlRespVo> query(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
        TpmFeeBudgetControlRespVo respVo=tpmFeeBudgetControlService.query(tpmFeeBudgetControlReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
        tpmFeeBudgetControlService.save(tpmFeeBudgetControlReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
        tpmFeeBudgetControlService.update(tpmFeeBudgetControlReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmFeeBudgetControlService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmFeeBudgetControlService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmFeeBudgetControlService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
