package com.biz.crm.feebudget.controller;

import cn.hutool.db.Page;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDistributionReqVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDistributionRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 费用预算
 *
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */
@Slf4j
@RestController
@RequestMapping("/tpmFeeBudgetController")
@Api(tags = "费用预算 ")
public class TpmFeeBudgetController {
    @Autowired
    private ITpmFeeBudgetService tpmFeeBudgetService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmFeeBudgetRespVo>> list(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        PageResult<TpmFeeBudgetRespVo> result=tpmFeeBudgetService.findList(tpmFeeBudgetReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmFeeBudgetRespVo> query(@RequestParam(value = "id",required = false)String id) {
        TpmFeeBudgetRespVo respVo=tpmFeeBudgetService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setLockUserName(user.getUsername());
        tpmFeeBudgetReqVo.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.INIT.getCode());
        tpmFeeBudgetService.save(tpmFeeBudgetReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setLockUserName(user.getUsername());
        tpmFeeBudgetReqVo.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.INIT.getCode());
        tpmFeeBudgetService.update(tpmFeeBudgetReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmFeeBudgetService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmFeeBudgetService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  List<String> ids) {
        tpmFeeBudgetService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 变更
     * @param tpmFeeBudgetReqVo
     * @return
     */
    @ApiOperation(value = "变更")
    @PostMapping("/change")
    @CrmLog
    public Result change(@RequestBody  TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setLockUserName(user.getUsername());
        tpmFeeBudgetService.change(tpmFeeBudgetReqVo);
        return Result.ok("变更成功");
    }
    /**
     * 调整
     * @param tpmFeeBudgetReqVo
     * @return
     */
    @ApiOperation(value = "调整")
    @PostMapping("/adjust")
    @CrmLog
    public Result adjust(@RequestBody  TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setLockUserName(user.getUsername());
        tpmFeeBudgetService.adjust(tpmFeeBudgetReqVo);
        return Result.ok("调整成功");
    }

    /**
     * 查询当前登录人所属组织的费用预算
     */
    @ApiOperation(value = "查询当前登录人所属组织的费用预算")
    @PostMapping("/feeBudgetInfoByUser")
    @CrmLog
    public Result<PageResult<TpmFeeBudgetRespVo>> feeBudgetInfoByUser(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        if(StringUtils.isNotEmpty(user.getOrgcode())){
            tpmFeeBudgetReqVo.setOrgCode(user.getOrgcode());
            tpmFeeBudgetReqVo.setFeeBudgetType(FeeBudgetTypeEnum.FIXED.getCode());
        }
        PageResult<TpmFeeBudgetRespVo> result=tpmFeeBudgetService.findList(tpmFeeBudgetReqVo);
        return Result.ok(result);
    }

    @ApiOperation("保存费用预算划拨")
    @PostMapping("saveDistribution")
    @CrmLog
    public Result<Object> saveDistribution(@RequestBody List<TpmFeeBudgetDistributionReqVo> reqVos){
        tpmFeeBudgetService.saveDistribution(reqVos);
        return Result.ok("保存成功");
    }
}
