package com.biz.crm.feebudget.model;

import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.tpm.feebudget.req
 * @ClassName OperateBudgetControlReqVo
 * @Author HuangLong
 * @Date 2020/10/26 15:15
 * @Description 费用预算维度操作请求vo
 */
@Data
@Builder
public class OperateBudgetControlReqVo implements Serializable {

    /**
     * 费用预算操作类型枚举
     */
    private FeeBudgetControlOperateTypeEnum typeEnum;


    /**
     * 本次操作的费用预算实体
     */
    private TpmFeeBudgetEntity entity;


    /**
     * 本次预算费用操作的请求vo
     */
    private TpmFeeBudgetReqVo reqVo;

    /**
     * 删除时用的
     */
    private TpmFeeBudgetControlEntity controlEntity;

    private BigDecimal controlUpdateAmount;


    /**
     * 费用预算变更后的可用余额
     */
    private BigDecimal afterChangeCanUseAmount;



}
