package com.biz.crm.feebudget.service;

import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;

import java.util.List;
import java.util.Map;

/**
 * 费用预算管控维度表 接口
 *
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */
public interface ITpmFeeBudgetControlService extends IService<TpmFeeBudgetControlEntity> {

    /**
     * 列表
     * @param tpmFeeBudgetControlReqVo
     * @return PageResult<TpmFeeBudgetControlRespVo>
     */
    PageResult<TpmFeeBudgetControlRespVo> findList(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);
    /**
     * 查询集合不分页
     * @param tpmFeeBudgetControlReqVo
     * @return List<TpmFeeBudgetControlRespVo>
     */
    List<TpmFeeBudgetControlRespVo> list(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    void convertListData(List<TpmFeeBudgetControlRespVo> list);
    /**
     * 查询
     * @param tpmFeeBudgetControlReqVo
     * @return TpmFeeBudgetControlRespVo
     */
    TpmFeeBudgetControlRespVo query(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 新增
     * @param tpmFeeBudgetControlReqVo
     * @return
     */
    void save(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 更新
     * @param tpmFeeBudgetControlReqVo
     * @return
     */
    void update(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

