package com.biz.crm.feebudget.service;

import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailReportReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailsRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailsReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailReportRespVo;

import java.util.List;

/**
 * 费用预算明细 接口
 *
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */
public interface ITpmFeeBudgetDetailsService extends IService<TpmFeeBudgetDetailsEntity> {

    /**
     * 列表
     * @param tpmFeeBudgetDetailsReqVo
     * @return PageResult<TpmFeeBudgetDetailsRespVo>
     */
    PageResult<TpmFeeBudgetDetailsRespVo> findList(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 查询
     * @param tpmFeeBudgetDetailsReqVo
     * @return TpmFeeBudgetDetailsRespVo
     */
    TpmFeeBudgetDetailsRespVo query(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 新增
     * @param tpmFeeBudgetDetailsReqVo
     * @return
     */
    void save(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 更新
     * @param tpmFeeBudgetDetailsReqVo
     * @return
     */
    void update(TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 费用预算明细报表
     * @param reportReqVo
     * @return
     */
    PageResult<TpmFeeBudgetDetailReportRespVo> feeBudgetDetailReport(TpmFeeBudgetDetailReportReqVo reportReqVo);
}

