package com.biz.crm.feewithholding.controller;

import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.feewithholding.service.ITpmFeeWithholdingService;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmFeeWithholdingActRespVo;
import com.biz.crm.nebular.tpm.feewithholding.req.TpmFeeWithholdingReqVo;
import com.biz.crm.nebular.tpm.feewithholding.resp.TpmFeeWithholdingRespVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * 
 *
 * @author gavin
 * @date 2021-12-15 15:36:08
 */
@Slf4j
@RestController
@RequestMapping("/tpmfeewithholding")
@Api(tags = "费用预提")
public class TpmFeeWithholdingController {
    @Autowired
    private ITpmFeeWithholdingService tpmFeeWithholdingService;

    @Autowired
    private ITpmActService tpmActService;
    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmFeeWithholdingRespVo>> list(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        PageResult<TpmFeeWithholdingRespVo> result=tpmFeeWithholdingService.findList(tpmFeeWithholdingReqVo);
        return Result.ok(result);
    }

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/actList")
    @CrmLog
    public Result<PageResult<TpmActRespVo>> actList(@RequestBody TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setMaxYearMonth(DateUtil.getFormatDateStr(new Date(), DateUtil.DEFAULT_MONTH_DAY_PATTERN_));
        tpmActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        PageResult<TpmActRespVo> result = tpmActService.findList(tpmActReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmFeeWithholdingRespVo> query(@RequestParam("id")String id) {
        TpmFeeWithholdingRespVo respVo=tpmFeeWithholdingService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 自动预提
     */
    @ApiOperation(value = "自动预提")
    @PostMapping("/auto")
    @CrmLog
    public Result auto(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        tpmFeeWithholdingService.auto(tpmFeeWithholdingReqVo);
        return Result.ok();
    }

    /**
     * 手工预提
     */
    @ApiOperation(value = "手工预提")
    @PostMapping("/handle")
    @CrmLog
    public Result handle(@RequestBody List<TpmFeeWithholdingReqVo> reqVos) {
        tpmFeeWithholdingService.handle(reqVos);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        tpmFeeWithholdingService.update(tpmFeeWithholdingReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmFeeWithholdingService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        tpmFeeWithholdingService.enableBatch(tpmFeeWithholdingReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        tpmFeeWithholdingService.disableBatch(tpmFeeWithholdingReqVo);
        return Result.ok("禁用成功");
    }

    @ApiOperation(value = "手工新增费用预提查找活动明细")
    @PostMapping("findActDetailByFeeWithholding")
    @CrmLog
    public Result<List<TpmFeeWithholdingActRespVo>> findActDetailByFeeWithholding(@RequestBody List<String> actCodeList){
        List<TpmFeeWithholdingActRespVo> result = tpmFeeWithholdingService.findActDetailByFeeWithholding(actCodeList);
        return Result.ok(result);
    }
}
