package com.biz.crm.feewithholding.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 实体类
 *
 * @author gavin
 * @date 2021-12-15 15:36:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_fee_withholding")
@CrmTable(name = "tpm_fee_withholding", tableNote = "")
public class TpmFeeWithholdingEntity extends CrmExtTenEntity<TpmFeeWithholdingEntity> {


    /**
     * 预提类型字典值
     */
    @CrmColumn(name = "withholding_type", length = 10, note = "预提类型字典值")
    private String withholdingType;


    /**
     * 推送状态字典值
     */
    @CrmColumn(name = "send_status", length = 10, note = "推送状态字典值")
    private String sendStatus;


    /**
     * 预提编码
     */
    @CrmColumn(name = "withholding_code", length = 60, note = "预提编码")
    private String withholdingCode;


    /**
     * 预提年月
     */
    @CrmColumn(name = "year_and_month", length = 10, note = "预提年月")
    private String yearAndMonth;

    /**
     * 预提金额
     */
    @CrmColumn(name = "withholding_amount", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "预提金额")
    private BigDecimal withholdingAmount;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 60, note = "活动明细编码")
    private String actDetailCode;
}
