package com.biz.crm.feewithholding.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.feewithholding.model.TpmFeeWithholdingEntity;
import com.biz.crm.nebular.tpm.act.resp.TpmFeeWithholdingActRespVo;
import com.biz.crm.nebular.tpm.feewithholding.req.TpmFeeWithholdingReqVo;
import com.biz.crm.nebular.tpm.feewithholding.resp.TpmFeeWithholdingRespVo;
import com.biz.crm.common.PageResult;

import java.util.List;

/**
 * 接口
 *
 * @author gavin
 * @date 2021-12-15 15:36:08
 */
public interface ITpmFeeWithholdingService extends IService<TpmFeeWithholdingEntity> {

    /**
     * 列表
     * @param tpmFeeWithholdingReqVo
     * @return PageResult<TpmFeeWithholdingRespVo>
     */
    PageResult<TpmFeeWithholdingRespVo> findList(TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo);

    /**
     * 查询
     * @param id
     * @return TpmFeeWithholdingRespVo
     */
    TpmFeeWithholdingRespVo query(String id);

    /**
     * 新增
     * @param tpmFeeWithholdingReqVo
     * @return
     */
    void auto(TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo);


    /**
     * 新增
     * @param reqVos
     * @return
     */
    void handle(List<TpmFeeWithholdingReqVo> reqVos);

    /**
     * 更新
     * @param tpmFeeWithholdingReqVo
     * @return
     */
    void update(TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param tpmFeeWithholdingReqVo
     * @return
     */
    void enableBatch(TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo);

    /**
     * 禁用
     * @param tpmFeeWithholdingReqVo
     * @return
     */
    void disableBatch(TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo);

    /**
     * 查找
     * @return
     */
    List<TpmFeeWithholdingActRespVo> findActDetailByFeeWithholding(List<String> actCodeList);
}

