package com.biz.crm.financesubject.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.financesubject.service.TpmFinanceSubjectService;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/2/20.
 */
@Slf4j
@RestController
@RequestMapping("/tpmFinanceSubjectController")
@Api(tags = "财务科目表 ")
public class TpmFinanceSubjectController {
    @Autowired
    private TpmFinanceSubjectService financeSubjectService;

    /**
     * 列表查询
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmFinanceSubjectRespVo>> list(@RequestBody TpmFinanceSubjectReqVo reqVo){
        PageResult<TpmFinanceSubjectRespVo> result = financeSubjectService.findList(reqVo);
        return Result.ok(result);
    }

    /**
     * 查看单个
     * @param id
     * @return
     */
    @ApiOperation("/查看")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmFinanceSubjectRespVo> query(@RequestParam(value = "id", required = false) String id){
        TpmFinanceSubjectRespVo tpmFinanceSubjectRespVo = financeSubjectService.queryView(id);
        return Result.ok(tpmFinanceSubjectRespVo);
    }

    /**
     * 新增财务科目
     * @param reqVo
     * @return
     */
    @PostMapping("/save")
    @ApiOperation("/新增")
    @CrmLog
    public Result save(@RequestBody TpmFinanceSubjectReqVo reqVo){
        financeSubjectService.save(reqVo);
        return Result.ok("操作成功");
   }

    /**
     * 修改财务科目
     * @param reqVo
     * @return
     */
    @PostMapping("/update")
    @ApiOperation("/修改")
    @CrmLog
    public Result update(@RequestBody TpmFinanceSubjectReqVo reqVo){
        financeSubjectService.update(reqVo);
        return Result.ok("操作成功");
    }


    /**
     * 批量删除财务科目
     * @param ids ids
     * @return
     */
    @PostMapping("/delete")
    @ApiOperation("/批量删除")
    @CrmLog
    public Result delete(@RequestBody List<String> ids){
        financeSubjectService.batchDelete(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量禁用
     * @param ids
     * @return
     */
    @PostMapping("/disable")
    @ApiOperation("/批量禁用")
    @CrmLog
    public Result disable(@RequestBody List<String> ids){
        financeSubjectService.batchDisable(ids);
        return Result.ok("操作成功");
    }

    /**
     * 批量启用
     * @param ids
     * @return
     */
    @PostMapping("/enable")
    @ApiOperation("/批量启用")
    @CrmLog
    public Result enable(@RequestBody List<String> ids){
        financeSubjectService.batchEnable(ids);
        return Result.ok("操作成功");
    }
}
