package com.biz.crm.financesubject.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/2/20.
 */
public interface TpmFinanceSubjectMapper extends BaseMapper<TpmFinanceSubjectEntity> {
    /**
     * 查询列表
     * 可模糊查询
     *      根据编码 名称（输入）
     *      根据 状态 类型（下拉框）
     * @param page
     * @param tpmFinanceSubjectReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmFinanceSubjectRespVo> findList(Page<TpmFinanceSubjectRespVo> page,  @Param("vo") TpmFinanceSubjectReqVo tpmFinanceSubjectReqVo );
}
