package com.biz.crm.financesubject.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.collections4.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.exception.CommonException;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author maoshen
 * @date 2021/2/20.
 */
@Service
@Slf4j
public class FinanceSubjectHelp {

    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;

    public Map<String, Map<String, String>> getDicts() {
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.FINANCE_SUBJECT_TYPE);
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }

    /**
     * 设置列表和查看的数据
     * @param respVo respVo
     */
    public void setRespVoData(TpmFinanceSubjectRespVo respVo) {
        Map<String,Map<String,String>> dataMaps = this.getDicts();
        if (StringUtils.isNotBlank(respVo.getFinanceSubjectType())){
            respVo.setFinanceSubjectTypeDesc(Optional.ofNullable(dataMaps.get(TpmGlobalDictConstants.FINANCE_SUBJECT_TYPE))
                    .orElse(Maps.newHashMap()).get(respVo.getFinanceSubjectType()));
        }
        if (StringUtils.isNotBlank(respVo.getEnableStatus())){
            respVo.setEnableStatusName(Optional.ofNullable(dataMaps.get(TpmGlobalDictConstants.ENABLE_STATUS))
                    .orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
        }
    }

    /**
     * 新增修改数据校验
     * @param reqVo
     */
    public void checkData(TpmFinanceSubjectReqVo reqVo) {
        if (StringUtils.isBlank(reqVo.getFinanceSubjectCode())){
            reqVo.setFinanceSubjectCode(CodeUtil.generateCode(CrmCodeRuleConstants.FINANCE_SUBJECT));
        }
        AssertUtils.isNotEmpty(reqVo.getFinanceSubjectName(),"财务科目名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getFinanceSubjectType(),"财务科目类型不能为空");
        this.checkExist(reqVo);
    }

    /**
     * 判断重复
     * @param reqVo
     */
    private void checkExist(TpmFinanceSubjectReqVo reqVo){
        LambdaQueryWrapper<TpmFinanceSubjectEntity> wrapper = Wrappers.<TpmFinanceSubjectEntity>lambdaQuery()
                .eq(TpmFinanceSubjectEntity::getFinanceSubjectCode,reqVo.getFinanceSubjectCode());
        if (StringUtils.isNotEmpty(reqVo.getId())){
            wrapper.ne(TpmFinanceSubjectEntity::getId,reqVo.getId());
        }
        List<TpmFinanceSubjectEntity> entities = financeSubjectMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("该编码已经存在");
        }
    }

    public void updateCheck(TpmFinanceSubjectReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(), CommonException.IDS_NULL);
        List<TpmFinanceSubjectEntity> list = financeSubjectMapper.
                selectList(Wrappers.<TpmFinanceSubjectEntity>lambdaQuery().eq(TpmFinanceSubjectEntity::getId,reqVo.getId()));
        if (CollectionUtils.size(list)>1){
            throw new BusinessException("结果大于1条，数据异常");
        }
        if (CollectionUtils.size(list)<1){
            throw new BusinessException("修改数据不存在");
        }
    }
}
