package com.biz.crm.financesubject.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.financesubject.service.TpmFinanceSubjectService;
import com.biz.crm.fiscalyear.service.ITpmFiscalYearSettingService;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author maoshen
 * @date 2021/2/20.
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmFinanceSubjectServiceImpl")
public class TpmFinanceSubjectServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmFinanceSubjectMapper, TpmFinanceSubjectEntity> implements TpmFinanceSubjectService {

    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;

    @Autowired
    private FinanceSubjectHelp financeSubjectHelp;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Resource
    private ActServiceHelper serviceHelper;

    @Override
    public PageResult<TpmFinanceSubjectRespVo> findList(TpmFinanceSubjectReqVo reqVo) {
        Page<TpmFinanceSubjectRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setSelectedCodeList(serviceHelper.dealSelectedCodeList(reqVo.getSelectedCode(),reqVo.getSelectedCodeList()));
        List<TpmFinanceSubjectRespVo> list = financeSubjectMapper.findList(page, reqVo);
        if (CollectionUtils.isNotEmpty(list)){
            list.forEach(o->{
                financeSubjectHelp.setRespVoData(o);
            });
        }
        return PageResult.<TpmFinanceSubjectRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查看单个
     * @param id
     * @return
     */
    @Override
    public TpmFinanceSubjectRespVo queryView(String id) {
        AssertUtils.isNotEmpty(id, CommonException.IDS_NULL);
        List<TpmFinanceSubjectEntity> financeSubjectEntities = financeSubjectMapper
                .selectList(Wrappers.<TpmFinanceSubjectEntity>lambdaQuery()
                .eq(TpmFinanceSubjectEntity::getId,id));
        if (CollectionUtils.size(financeSubjectEntities)>1){
            throw new BusinessException("查询结果大于1条");
        }
        if (CollectionUtils.isEmpty(financeSubjectEntities)){
            throw new BusinessException("数据不存在");
        }
        TpmFinanceSubjectRespVo respVo = CrmBeanUtil.copy(financeSubjectEntities.get(0),TpmFinanceSubjectRespVo.class);
        financeSubjectHelp.setRespVoData(respVo);
        return respVo;
    }

    /**
     * 新增财务科目
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void save(TpmFinanceSubjectReqVo reqVo) {
        financeSubjectHelp.checkData(reqVo);
        TpmFinanceSubjectEntity tpmFinanceSubjectEntity = CrmBeanUtil.copy(reqVo,TpmFinanceSubjectEntity.class);
        this.save(tpmFinanceSubjectEntity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmFinanceSubjectRespVo newData = CrmBeanUtil.copy(tpmFinanceSubjectEntity, TpmFinanceSubjectRespVo.class);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getFinanceSubjectCode(),newData);
    }

    /**
     * 修改财务科目
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(TpmFinanceSubjectReqVo reqVo) {
        //日志老数据
        TpmFinanceSubjectRespVo oldData = this.queryView(reqVo.getId());
        financeSubjectHelp.updateCheck(reqVo);
        financeSubjectHelp.checkData(reqVo);
        TpmFinanceSubjectEntity tpmFinanceSubjectEntity = CrmBeanUtil.copy(reqVo,TpmFinanceSubjectEntity.class);
        this.updateById(tpmFinanceSubjectEntity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmFinanceSubjectRespVo newData = CrmBeanUtil.copy(tpmFinanceSubjectEntity, TpmFinanceSubjectRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getFinanceSubjectCode(),oldData,newData);
    }

    /**
     * 批量删除财务科目
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchDelete(List<String> ids) {
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        List<TpmFinanceSubjectEntity> entities = financeSubjectMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmFinanceSubjectRespVo> oldDataList = CrmBeanUtil.copyList(entities,TpmFinanceSubjectRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)){
            List<String> removeIds = Lists.newArrayList();
            entities.forEach(o->{
                removeIds.add(o.getId());
            });
            this.removeByIds(removeIds);
        }
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        oldDataList.forEach(o->{
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),o.getId(),o.getFinanceSubjectCode(),o);
        });
    }

    /**
     * 批量禁用
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchDisable(List<String> ids) {
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        List<TpmFinanceSubjectEntity> entities = financeSubjectMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmFinanceSubjectRespVo> oldDataList = CrmBeanUtil.copyList(entities,TpmFinanceSubjectRespVo.class);
        if(CollectionUtils.isNotEmpty(entities)){
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
            this.updateBatchById(entities);
        }
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmFinanceSubjectRespVo> newDataList = CrmBeanUtil.copyList(entities,TpmFinanceSubjectRespVo.class);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getFinanceSubjectCode(),oldDataList.get(i),newDataList.get(i));
        }
    }

    /**
     * 批量启用
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchEnable(List<String> ids) {
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        List<TpmFinanceSubjectEntity> entities = financeSubjectMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmFinanceSubjectRespVo> oldDataList = CrmBeanUtil.copyList(entities,TpmFinanceSubjectRespVo.class);
        if(CollectionUtils.isNotEmpty(entities)){
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
            this.updateBatchById(entities);
        }
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmFinanceSubjectRespVo> newDataList = CrmBeanUtil.copyList(entities,TpmFinanceSubjectRespVo.class);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getFinanceSubjectCode(),oldDataList.get(i),newDataList.get(i));
        }
    }
}
