package com.biz.crm.fiscalyear.controller;

import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.fiscalyear.service.ITpmFiscalYearSettingService;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import javax.annotation.Resource;
import java.util.List;

/**
 * 财年设置 财年设置表
 *
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */
@Slf4j
@RestController
@RequestMapping("/tpmFiscalYearSettingController")
@Api(tags = "财年设置 财年设置表")
public class TpmFiscalYearSettingController { 
    @Resource
    private ITpmFiscalYearSettingService tpmFiscalYearSettingService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmFiscalYearSettingRespVo>> list(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        PageResult<TpmFiscalYearSettingRespVo> result=tpmFiscalYearSettingService.findList(tpmFiscalYearSettingReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmFiscalYearSettingRespVo> query(@RequestParam(value = "id",required = false) String id) {
        TpmFiscalYearSettingRespVo respVo=tpmFiscalYearSettingService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        tpmFiscalYearSettingService.save(tpmFiscalYearSettingReqVo);
        return Result.ok("新增成功");
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        tpmFiscalYearSettingService.update(tpmFiscalYearSettingReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmFiscalYearSettingService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmFiscalYearSettingService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmFiscalYearSettingService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
