package com.biz.crm.income.service;

import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.Map;

/**
 * 收入预算;接口
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */
public interface ITpmIncomeBudgetService extends IService<TpmIncomeBudgetEntity> {

    /**
     * 列表
     * @param tpmIncomeBudgetReqVo
     * @return PageResult<TpmIncomeBudgetRespVo>
     */
    PageResult<TpmIncomeBudgetRespVo> findList(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 查询
     * @param id
     * @return TpmIncomeBudgetRespVo
     */
    TpmIncomeBudgetRespVo query(String id);

    /**
     * 新增
     * @param tpmIncomeBudgetReqVo
     * @return
     */
    void save(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 更新
     * @param tpmIncomeBudgetReqVo
     * @return
     */
    void update(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     *  批量删除
     * @param ids ids
     */
    void batchDelete(List<String> ids);

    /**
     * 收入预算新增 获取所有组织
     * @param mdmOrgReqVo
     * @return
     */
    List<MdmOrgRespVo> findAllOrgCodes(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 根据 组织查询 组织及下级组织所对应的客户
     * @param mdmOrgReqVo
     * @return
     */
    List<MdmCustomerMsgRespVo> findCustomerByOrgCode(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 根据 组织查询 组织及下级组织所对应的门店
     * @param mdmOrgReqVo
     * @return
     */
    List<MdmTerminalVo> findTerminalByOrgCode(MdmOrgReqVo mdmOrgReqVo);

    /**
     * 收入预算新增 获取所有产品
     * @param mdmProductReqVo
     * @return
     */
    List<MdmProductRespVo> findAllProduct(MdmProductReqVo mdmProductReqVo);

    /**
     * 根据所选产品层级 获得 所有该层级或下级的产品
     * @param mdmProductLevelSelectReqVo
     * @return
     */
    List<MdmProductQueryRespVo> findAllProductByLevelCode(MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo);

    /**
     * 获取产品层级
     * @param mdmProductLevelSelectReqVo
     * @return
     */
    List<MdmProductLevelSelectRespVo> findAllProductLevel(MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo);
}

