package com.biz.crm.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.income.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.*;

/**
 * @author maoshen
 * @date 2021/2/3.
 */
@Service
public class InComeServiceHelp {

    @Autowired
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmTerminalFeign terminalFeign;
    @Resource
    private TpmIncomeBudgetMapper incomeBudgetMapper;
    @Autowired
    private MdmProductFeign productFeign;
    @Autowired
    private MdmProductLevelFeign mdmProductLevelFeign;

    public Map<String, Map<String, String>> getDicts() {
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.FEE_BUDGET_TYPE);
        dictCodes.add(TpmGlobalDictConstants.FISCAL_MONTH);
        dictCodes.add(TpmGlobalDictConstants.BUDGET_YEAR);
//        dictCodes.add(TpmGlobalDictConstants.INCOME_TYPE);
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        dictCodes.add(TpmGlobalDictConstants.CHANNEL);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }

    public void checkData(TpmIncomeBudgetReqVo reqVo) {
        Map<String,Map<String,String>> globalMaps = this.getDicts();
        if (StringUtils.isEmpty(reqVo.getIncomeCode())) {
            reqVo.setIncomeCode(CodeUtil.createOneCode(CrmCodeRuleConstants.INCOME_BUDGET));
        }
        AssertUtils.isNotEmpty(reqVo.getFeeBudgetType(), "请选择分组");
        if (!Optional.ofNullable(globalMaps.get(TpmGlobalDictConstants.FEE_BUDGET_TYPE))
                .orElse(Maps.newHashMap()).containsKey(reqVo.getFeeBudgetType())) {
            throw new BusinessException("所选分组不存在");
        }
        //填了产品层级非必填,填了则校验有效性
        if(StringUtils.isNotBlank(reqVo.getProductLevelCode())){
            MdmProductLevelRespVo productLevelRespVo =ApiResultUtil.objResult(mdmProductLevelFeign.detail("",reqVo.getProductLevelCode()));
            AssertUtils.isNotNull(productLevelRespVo,"不存在该产品层级");
            reqVo.setProductLevelName(productLevelRespVo.getProductLevelName());
            //产品编码非必填,填了校验有效性
            if(StringUtils.isNotBlank(reqVo.getProductCode())) {
                List<String> productLevelCodeList = Collections.singletonList(reqVo.getProductLevelCode());
                List<MdmProductRespVo> productRespVos = ApiResultUtil.objResult(productFeign.queryBatchByProductLevelCodeList(productLevelCodeList));
                Map<String, MdmProductRespVo> productRespVoMap = productRespVos.stream()
                        .collect(toMap(MdmProductRespVo::getProductCode, Function.identity()));
                if (!productRespVoMap.containsKey(reqVo.getProductCode())) {
                    throw new BusinessException("产品不属于所选层级");
                }
                reqVo.setProductName(productRespVoMap.get(reqVo.getProductCode()).getProductName());
            }else {
                reqVo.setProductCode(null);
            }
        }else {
            reqVo.setProductLevelCode(null);
        }
        reqVo.setFeeBudgetTypeName(globalMaps.get(TpmGlobalDictConstants.FEE_BUDGET_TYPE).get(reqVo.getFeeBudgetType()));
        // 选择组织 数据来源与 TpmIncomeBudgetController/findAllOrgCodes
        AssertUtils.isNotEmpty(reqVo.getOrgCode(), "组织不能为空");
        MdmOrgRespVo mdmOrgRespVo =ApiResultUtil.objResult(mdmOrgFeign.detail(reqVo.getOrgCode()));
        AssertUtils.isNotNull(mdmOrgRespVo,"组织不存在");
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCode(UserUtils.getUser().getOrgcode());
        List<MdmOrgRespVo> orgRespVos = ApiResultUtil.objResult(mdmOrgFeign.findAllChildrenOrgList(mdmOrgReqVo));
        Map<String ,MdmOrgRespVo> orgRespVoMap = orgRespVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode,Function.identity()));
        if (!orgRespVoMap.containsKey(reqVo.getOrgCode())){
            throw new BusinessException("只能选择自己的组织或下级组织");
        }
        reqVo.setOrgName(orgRespVoMap.get(reqVo.getOrgCode()).getOrgName());
        List<String> orgCodes = Collections.singletonList(reqVo.getOrgCode());
        // 选择渠道
        if (StringUtils.equals(reqVo.getFeeBudgetType(), FeeBudgetTypeEnum.CHANNEL.getCode())) {
            if (!Optional.ofNullable(globalMaps.get(TpmGlobalDictConstants.CHANNEL)).orElse(Maps.newHashMap())
                    .containsKey(reqVo.getChannel())){
                throw new BusinessException("渠道类型不正确");
            }
            reqVo.setChannelName(globalMaps.get(TpmGlobalDictConstants.CHANNEL).get(reqVo.getChannel()));
            clearCustomerInfo(reqVo);
            clearTerminalInfo(reqVo);
        }else if(StringUtils.equals(reqVo.getFeeBudgetType(), FeeBudgetTypeEnum.CUSTOMER.getCode()) || StringUtils.equals(reqVo.getFeeBudgetType(), FeeBudgetTypeEnum.TERMINAL.getCode())){
            clearChannelInfo(reqVo);
            //选中客户或者门店
            this.setCustomerData(reqVo, orgCodes);
            // 选择门店 数据来源于 TpmIncomeBudgetController/findAllOrgCodes
            if (StringUtils.equals(reqVo.getFeeBudgetType(), FeeBudgetTypeEnum.TERMINAL.getCode())) {
                AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "分组为门店时，门店不能为空");
                MdmCustomerTerminalVo mdmCustomerTerminalVo = new MdmCustomerTerminalVo();
                // 通过客户
                List<String> customerList = Collections.singletonList(reqVo.getCustomerCode());
                mdmCustomerTerminalVo.setCustomerCodeList(customerList);
                MdmTerminalVo mdmTerminalVo =ApiResultUtil.objResult(terminalFeign.query("",reqVo.getTerminalCode()));
                AssertUtils.isNotNull(mdmTerminalVo,"门店不存在");
                List<MdmTerminalVo> mdmTerminalVos =ApiResultUtil.objResult(terminalFeign.customerTerminalList(mdmCustomerTerminalVo));
                Map<String,MdmTerminalVo> mdmTerminalVoMap = mdmTerminalVos.stream().collect(toMap(MdmTerminalVo::getTerminalCode,Function.identity()));
                if (!mdmTerminalVoMap.containsKey(reqVo.getTerminalCode())) {
                    throw new BusinessException("门店不属于所选客户");
                }
                reqVo.setTerminalName(mdmTerminalVoMap.get(reqVo.getTerminalCode()).getTerminalName());
            }else {
                clearTerminalInfo(reqVo);
            }
        }else{
            clearChannelInfo(reqVo);
            clearTerminalInfo(reqVo);
            clearCustomerInfo(reqVo);
        }
        AssertUtils.isNotEmpty(reqVo.getInitAmount().toString(), "金额不能为空");
        AssertUtils.isNotEmpty(reqVo.getBudgetYear(),"预算年份不能为空");
        AssertUtils.isNotEmpty(reqVo.getBudgetMonth(),"预算月份不能为空");
        this.checkIsExist(reqVo);
    }

    private void clearCustomerInfo(TpmIncomeBudgetReqVo reqVo){
        reqVo.setCustomerCode(null);
        reqVo.setCustomerName(null);
        reqVo.setCustomerOrgCode(null);
        reqVo.setCustomerOrgName(null);
    }

    private void clearTerminalInfo(TpmIncomeBudgetReqVo reqVo){
        reqVo.setTerminalCode(null);
        reqVo.setTerminalName(null);
    }

    private void clearChannelInfo(TpmIncomeBudgetReqVo reqVo){
        reqVo.setChannelName(null);
        reqVo.setChannel(null);
    }

    /**
     * 新增编辑检验 编码 和 年月 是否重复
     * @param reqVo vo
     */
    private void checkIsExist(TpmIncomeBudgetReqVo reqVo) {
        LambdaQueryWrapper<TpmIncomeBudgetEntity> wrappers = Wrappers.<TpmIncomeBudgetEntity>lambdaQuery()
                .eq(TpmIncomeBudgetEntity::getIncomeCode, reqVo.getIncomeCode());
        if (StringUtils.isNotEmpty(reqVo.getId())) {
            wrappers.ne(TpmIncomeBudgetEntity::getId, reqVo.getId());
        }
        int count = CollectionUtils.size(incomeBudgetMapper.selectList(wrappers));
        if (count>0){
            if (count == 1){
                throw new BusinessException("该编码存在");
            }
            throw new BusinessException("数据库异常");
        }
        LambdaQueryWrapper<TpmIncomeBudgetEntity> queryWrapper = Wrappers.<TpmIncomeBudgetEntity>lambdaQuery();
        queryWrapper.eq(TpmIncomeBudgetEntity::getFeeBudgetType, reqVo.getFeeBudgetType());
        queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetMonth,reqVo.getBudgetMonth());
        queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetYear,reqVo.getBudgetYear());
        if (StringUtils.isNotEmpty(reqVo.getId())) {
            queryWrapper.ne(TpmIncomeBudgetEntity::getId, reqVo.getId());
        }
        if (reqVo.getProductLevelCode() != null){
            queryWrapper.eq(TpmIncomeBudgetEntity::getProductLevelCode,reqVo.getProductLevelCode());
        }else {
            queryWrapper.isNull(TpmIncomeBudgetEntity::getProductLevelCode);
        }
        if (reqVo.getProductCode() != null){
            queryWrapper.eq(TpmIncomeBudgetEntity::getProductCode,reqVo.getProductCode());
        }else {
            queryWrapper.isNull(TpmIncomeBudgetEntity::getProductCode);
        }
        // 分组 组织
        queryWrapper.eq(TpmIncomeBudgetEntity::getOrgCode,reqVo.getOrgCode());
        // 分组 客户
        if (reqVo.getCustomerCode() != null){
            queryWrapper.eq(TpmIncomeBudgetEntity::getCustomerCode,reqVo.getCustomerCode());
        }
        if(reqVo.getChannel() != null){
            queryWrapper.eq(TpmIncomeBudgetEntity::getChannel,reqVo.getChannel());
        }
        // 分组 门店
        if (reqVo.getTerminalCode() != null){
            queryWrapper.eq(TpmIncomeBudgetEntity::getTerminalCode,reqVo.getTerminalCode());
        }
        int countSize = incomeBudgetMapper.selectCount(queryWrapper);
        if (countSize>0){
            if (countSize == 1){
                throw new BusinessException("该预算存在相同年月");
            }
            throw new BusinessException("数据库异常");
        }
    }

    /**
     * 设置 客户
     * @param reqVo
     * @param orgCodes
     */
    private void setCustomerData(TpmIncomeBudgetReqVo reqVo, List<String> orgCodes) {
        AssertUtils.isNotEmpty(reqVo.getCustomerCode(),"分组为客户/门店时，客户不能为空");
        // 设置reqVo.setCustomerName()
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setOrgCodeList(orgCodes);
        Map<String, MdmCustomerMsgRespVo> customerMsgRespVoMap
                =ApiResultUtil.objResult(mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo)).stream()
                        .collect(toMap(MdmCustomerMsgRespVo::getCustomerCode, Function.identity()));
        if (!customerMsgRespVoMap.containsKey(reqVo.getCustomerCode())){
            throw new BusinessException("客户不属于所选组织");
        }
        MdmCustomerMsgRespVo customerMsgRespVo = ApiResultUtil.objResult(mdmCustomerMsgFeign.query("",reqVo.getCustomerCode()));
        AssertUtils.isNotNull(customerMsgRespVo,"客户不存在");
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = customerMsgRespVoMap.get(reqVo.getCustomerCode());
        reqVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        reqVo.setCustomerOrgCode(mdmCustomerMsgRespVo.getCustomerOrgCode());
        if (StringUtils.isNotEmpty(reqVo.getCustomerOrgCode())){
            CusOrgVo cusOrgVo =ApiResultUtil.objResult(mdmCusOrgFeign.query("",reqVo.getCustomerOrgCode()));
            if (Objects.nonNull(cusOrgVo)){
                reqVo.setCustomerOrgName(cusOrgVo.getCustomerOrgName());
            }
        }
    }

    /**
     * 转换查看或列表数据
     * @param respVo 返回vo
     */
    public void setRespVoData(TpmIncomeBudgetRespVo respVo ) {
            Map<String,Map<String,String>> globalMaps = this.getDicts();
            if (StringUtils.isNotEmpty(respVo.getBudgetMonth())){
                respVo.setBudgetMonthDesc(Optional.ofNullable(globalMaps.get(TpmGlobalDictConstants.FISCAL_MONTH))
                        .orElse(Maps.newHashMap()).get(respVo.getBudgetMonth()));
            }
            if (StringUtils.isNotEmpty(respVo.getBudgetYear())){
                respVo.setBudgetYearDesc(Optional.ofNullable(globalMaps.get(TpmGlobalDictConstants.BUDGET_YEAR))
                        .orElse(Maps.newHashMap()).get(respVo.getBudgetYear()));
            if (StringUtils.isNotEmpty(respVo.getEnableStatus())){
                respVo.setEnableStatusName(Optional.ofNullable(globalMaps.get(TpmGlobalDictConstants.ENABLE_STATUS))
                        .orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
            }
//            if (StringUtils.isNotEmpty(respVo.getIncomeType())){
//                respVo.setIncomeTypeName(Optional.ofNullable(globalMaps.get(TpmGlobalDictConstants.INCOME_TYPE))
//                        .orElse(Maps.newHashMap()).get(respVo.getIncomeType()));
//            }
        }
    }

    /**
     * 修改检验 id 和数据 是否存在
     * @param reqVo
     */
    public void updateCheck(TpmIncomeBudgetReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),"收入预算id不能为空");
        List<TpmIncomeBudgetEntity> listEntity = incomeBudgetMapper.selectList(Wrappers.<TpmIncomeBudgetEntity>lambdaQuery()
                .eq(TpmIncomeBudgetEntity::getId,reqVo.getId()));
        if (CollectionUtils.size(listEntity)>1){
            throw new BusinessException("数据异常");
        }
        if (CollectionUtils.size(listEntity)<1){
            throw new BusinessException("修改数据不存在");
        }
    }

}