package com.biz.crm.liqueraudit.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditAttachService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 酒类TPM核销附加信息表;
 *
 * @author Huahongqiang
 * @date 2021-03-23 11:48:30
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueurauditattach")
@Api(tags = "酒类TPM核销附加信息表;")
public class TpmLiqueurAuditAttachController {
    @Autowired
    private ITpmLiqueurAuditAttachService tpmLiqueurAuditAttachService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurAuditAttachRespVo>> list(@RequestBody TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        PageResult<TpmLiqueurAuditAttachRespVo> result=tpmLiqueurAuditAttachService.findList(tpmLiqueurAuditAttachReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmLiqueurAuditAttachRespVo> query(@RequestBody TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        TpmLiqueurAuditAttachRespVo respVo=tpmLiqueurAuditAttachService.query(tpmLiqueurAuditAttachReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        tpmLiqueurAuditAttachService.save(tpmLiqueurAuditAttachReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        tpmLiqueurAuditAttachService.update(tpmLiqueurAuditAttachReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        tpmLiqueurAuditAttachService.deleteBatch(tpmLiqueurAuditAttachReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        tpmLiqueurAuditAttachService.enableBatch(tpmLiqueurAuditAttachReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo) {
        tpmLiqueurAuditAttachService.disableBatch(tpmLiqueurAuditAttachReqVo);
        return Result.ok("禁用成功");
    }


}
