package com.biz.crm.liqueraudit.model;

import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author jerry7
 * @date 2021/3/26 16:49
 */
@Data
public class LiqueurAuditVo {

    /**
     * transaction列表
     */
    private List<TpmLiqueurActBudgetTransactionEntity> transactionEntities;

    /**
     * businessCode-List<TpmLiqueurActBudgetTransactionEntity> map
     */
    private Map<String, List<TpmLiqueurActBudgetTransactionEntity>> transactionMap;

    /**
     * 活动预算列表
     */
    private List<TpmLiqueurActBudgetEntity> tpmLiqueurActBudgetEntities;

    /**
     * 活动预算编码-活动预算map
     */
    private Map<String, TpmLiqueurActBudgetEntity> actBudgetEntityMap;

    /**
     * 费用预算明细列表
     */
    private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities;

    /**
     * businessCode-List<TpmFeeBudgetDetailsEntity> map
     */
    private Map<String, List<TpmFeeBudgetDetailsEntity>> feeBudgetDetailMap;

    /**
     * 费用预算列表
     */
    private List<TpmFeeBudgetEntity> feeBudgetEntities;

    /**
     * 费用预算控制列表
     */
    private List<TpmFeeBudgetControlEntity> feeBudgetControlEntities;

    /**
     * 控制id，控制维度map
     */
    private Map<String, TpmFeeBudgetControlEntity> FeeBudgetControlEntityMap;

    /**
     * 预算编码，费用预算map
     */
    private Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap;

    /**
     * 核销明细列表
     */
    private List<TpmLiqueurAuditDetailsEntity> auditDetailsEntities;

    /**
     * 活动明细列表
     */
    private List<TpmLiqueurActRegisterDetailEntity> actRegisterDetailEntities;

    /**
     * 活动明细编码-活动明细map
     */
    private Map<String, TpmLiqueurActRegisterDetailEntity> actRegisterDetailEntityMap;

    /**
     * 活动详情列表
     */
    private List<TpmLiqueurActEntity> actEntities;

    /**
     * 活动编码-活动详情map
     */
    private Map<String,TpmLiqueurActEntity> actEntityMap;




}
