package com.biz.crm.liqueraudit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;



/**
 * 酒类TPM核销申请主表;实体类
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_audit")
@CrmTable(name = "tpm_liqueur_audit",tableNote = "TPM-酒类核销申请主表")
public class TpmLiqueurAuditEntity extends CrmExtEntity<TpmLiqueurAuditEntity> {

    /**
     * 核销申请名称
     */
    @CrmColumn(name = "audit_name", length = 60,note = "核销申请名称")
    private String auditName;

    /**
     * 核销申请编码
     */
    @CrmColumn(name = "audit_code", length = 32,note = "核销申请编码")
    private String auditCode;

    /**
     * 审批状态(字典)
     */
    @CrmColumn(name = "approve_status", length = 32,note = "审批状态(字典)")
    private String approveStatus;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 32,note = "流程编号")
    private String processCode;

    /**
     * 工作流key
     */
    @CrmColumn(name = "work_flow_key", length = 32,note = "工作流key")
    private String workFlowKey;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "work_flow_name", length = 60,note = "工作流名称")
    private String workFlowName;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

    /**
     * 总金额
     */
    @CrmColumn(name = "total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "总金额")
    private BigDecimal totalAmount;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "临时字段唯一值")
    private String actCode;

    @CrmColumn(name = "act_name", length = 32,note = "活动名称")
    private String actName;

    @CrmColumn(name = "fine_code", length = 32,note = "活动类型编码(活动细类)")
    private String fineCode;

    @CrmColumn(name = "audit_form_code", length = 32,note = "核销明细表单配置编码")
    private String auditFormCode;

    @CrmColumn(name = "is_allow_repeat_audit", length = 32,note = "是否允许多次核销")
    private String isAllowRepeatAudit;

    @CrmColumn(name = "bill_audit_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "上账核销金额")
    private BigDecimal billAuditAmount;

    @CrmColumn(name = "materials_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "总物料核销金额")
    private BigDecimal materialsAmount;

}
