package com.biz.crm.liqueraudit.service;

import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;

import java.util.Map;

/**
 * 酒类tpm核销明细表接口
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
public interface ITpmLiqueurAuditDetailsService extends IService<TpmLiqueurAuditDetailsEntity> {

    /**
     * 列表
     * @param tpmLiqueurAuditDetailsReqVo
     * @return PageResult<TpmLiqueurAuditDetailsRespVo>
     */
    PageResult<TpmLiqueurAuditDetailsRespVo> findList(TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo);

    /**
     * 查询
     * @param tpmLiqueurAuditDetailsReqVo
     * @return TpmLiqueurAuditDetailsRespVo
     */
    TpmLiqueurAuditDetailsRespVo query(TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo);

    /**
     * 新增
     * @param tpmLiqueurAuditDetailsReqVo
     * @return
     */
    void save(TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo);

    /**
     * 更新
     * @param tpmLiqueurAuditDetailsReqVo
     * @return
     */
    void update(TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo);

    /**
     * 删除
     * @param tpmLiqueurAuditDetailsReqVo
     * @return
     */
    void deleteBatch(TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo);

    /**
     * 启用
     * @param tpmLiqueurAuditDetailsReqVo
     * @return
     */
    void enableBatch(TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo);

    /**
     * 禁用
     * @param tpmLiqueurAuditDetailsReqVo
     * @return
     */
    void disableBatch(TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo);
}

