package com.biz.crm.liqueraudit.service.impl;

import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditAttachMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditAttachService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;
import java.util.List;

/**
 * 酒类TPM核销附加信息表;接口实现
 *
 * @author HuaHongqinag
 * @date 2021-03-23 11:48:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurAuditAttachServiceExpandImpl")
public class TpmLiqueurAuditAttachServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurAuditAttachMapper, TpmLiqueurAuditAttachEntity> implements ITpmLiqueurAuditAttachService {

    @Resource
    private TpmLiqueurAuditAttachMapper tpmLiqueurAuditAttachMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurAuditAttachRespVo> findList(TpmLiqueurAuditAttachReqVo reqVo){
        Page<TpmLiqueurAuditAttachRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurAuditAttachRespVo> list = tpmLiqueurAuditAttachMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurAuditAttachRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 上账核销附加信息列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurAuditAttachRespVo> findAccountList(TpmLiqueurAuditAttachReqVo reqVo){
        Page<TpmLiqueurAuditAttachRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurAuditAttachRespVo> list = tpmLiqueurAuditAttachMapper.findAccountList(page, reqVo);
        list.stream().forEach(o->{
            o.setCurrentAllowAmount(o.getAuditAmount().subtract(o.getFeeUsed()));
            o.setCustomerCode(o.getAttributionCusCode());
        });
        return PageResult.<TpmLiqueurAuditAttachRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmLiqueurAuditAttachRespVo
     */
    @Override
    public TpmLiqueurAuditAttachRespVo query(TpmLiqueurAuditAttachReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmLiqueurAuditAttachReqVo reqVo){
        TpmLiqueurAuditAttachEntity entity = CrmBeanUtil.copy(reqVo,TpmLiqueurAuditAttachEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmLiqueurAuditAttachReqVo reqVo){
        TpmLiqueurAuditAttachEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmLiqueurAuditAttachReqVo reqVo){
        List<TpmLiqueurAuditAttachEntity> tpmLiqueurAuditAttachEntities = tpmLiqueurAuditAttachMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditAttachEntities)){
            tpmLiqueurAuditAttachEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditAttachEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurAuditAttachReqVo reqVo){
        //设置状态为启用
        List<TpmLiqueurAuditAttachEntity> tpmLiqueurAuditAttachEntities = tpmLiqueurAuditAttachMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditAttachEntities)){
            tpmLiqueurAuditAttachEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditAttachEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurAuditAttachReqVo reqVo){
        //设置状态为禁用
        List<TpmLiqueurAuditAttachEntity> tpmLiqueurAuditAttachEntities = tpmLiqueurAuditAttachMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditAttachEntities)){
                tpmLiqueurAuditAttachEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditAttachEntities);
    }
}
