package com.biz.crm.liqueuract.controller;

import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetTransactionReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetTransactionRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 酒类活动预算使用明细表;
 *
 * @author lf
 * @date 2021-03-10 11:35:16
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueuractbudgettransaction")
@Api(tags = "酒类活动预算使用明细表;")
public class TpmLiqueurActBudgetTransactionController {
    @Autowired
    private ITpmLiqueurActBudgetTransactionService tpmLiqueurActBudgetTransactionService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurActBudgetTransactionRespVo>> list(@RequestBody TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo) {
        PageResult<TpmLiqueurActBudgetTransactionRespVo> result=tpmLiqueurActBudgetTransactionService.findList(tpmLiqueurActBudgetTransactionReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmLiqueurActBudgetTransactionRespVo> query(@RequestBody TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo) {
        TpmLiqueurActBudgetTransactionRespVo respVo=tpmLiqueurActBudgetTransactionService.query(tpmLiqueurActBudgetTransactionReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo) {
        tpmLiqueurActBudgetTransactionService.save(tpmLiqueurActBudgetTransactionReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo) {
        tpmLiqueurActBudgetTransactionService.update(tpmLiqueurActBudgetTransactionReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo) {
        tpmLiqueurActBudgetTransactionService.deleteBatch(tpmLiqueurActBudgetTransactionReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo) {
        tpmLiqueurActBudgetTransactionService.enableBatch(tpmLiqueurActBudgetTransactionReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo) {
        tpmLiqueurActBudgetTransactionService.disableBatch(tpmLiqueurActBudgetTransactionReqVo);
        return Result.ok("禁用成功");
    }
}
