package com.biz.crm.liqueuract.controller;

import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailBudgetService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailBudgetRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 酒类活动预算使用详情信息;
 *
 * @author lf
 * @date 2021-03-09 16:15:03
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueurbudgetuseddetail")
@Api(tags = "酒类活动预算使用详情信息;")
public class TpmLiqueurActRegisterDetailBudgetController {
    @Autowired
    private ITpmLiqueurActRegisterDetailBudgetService tpmLiqueurBudgetUsedDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterDetailBudgetRespVo>> list(@RequestBody TpmLiqueurActRegisterDetailBudgetReqVo tpmLiqueurActRegisterDetailBudgetReqVo) {
        PageResult<TpmLiqueurActRegisterDetailBudgetRespVo> result=tpmLiqueurBudgetUsedDetailService.findList(tpmLiqueurActRegisterDetailBudgetReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmLiqueurActRegisterDetailBudgetRespVo> query(@RequestBody TpmLiqueurActRegisterDetailBudgetReqVo tpmLiqueurActRegisterDetailBudgetReqVo) {
        TpmLiqueurActRegisterDetailBudgetRespVo respVo=tpmLiqueurBudgetUsedDetailService.query(tpmLiqueurActRegisterDetailBudgetReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActRegisterDetailBudgetReqVo tpmLiqueurActRegisterDetailBudgetReqVo) {
        tpmLiqueurBudgetUsedDetailService.save(tpmLiqueurActRegisterDetailBudgetReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActRegisterDetailBudgetReqVo tpmLiqueurActRegisterDetailBudgetReqVo) {
        tpmLiqueurBudgetUsedDetailService.update(tpmLiqueurActRegisterDetailBudgetReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurActRegisterDetailBudgetReqVo tpmLiqueurActRegisterDetailBudgetReqVo) {
        tpmLiqueurBudgetUsedDetailService.deleteBatch(tpmLiqueurActRegisterDetailBudgetReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurActRegisterDetailBudgetReqVo tpmLiqueurActRegisterDetailBudgetReqVo) {
        tpmLiqueurBudgetUsedDetailService.enableBatch(tpmLiqueurActRegisterDetailBudgetReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody TpmLiqueurActRegisterDetailBudgetReqVo tpmLiqueurActRegisterDetailBudgetReqVo) {
        tpmLiqueurBudgetUsedDetailService.disableBatch(tpmLiqueurActRegisterDetailBudgetReqVo);
        return Result.ok("禁用成功");
    }
}
