package com.biz.crm.liqueuract.mapper;

import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 酒类活动附件信息;
 * 
 * @author lf
 * @date 2021-03-08 18:06:17
 */
public interface TpmLiqueurActRegisterDetailMapper extends BaseMapper<TpmLiqueurActRegisterDetailEntity> {
    /**
     * 列表
     * @param page
     * @param tpmLiqueurActRegisterDetailReqVo
     * @return
     */
    List<TpmLiqueurActRegisterDetailRespVo> findList(Page<TpmLiqueurActRegisterDetailRespVo> page, @Param("vo") TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo);


    /**
     * 根据活动登记状态查询活动明细列表
     * @param page
     * @param tpmLiqueurActRegisterDetailReqVo
     * @return
     */
    List<TpmLiqueurActRegisterDetailRespVo> findDetailByRegisterStatus(Page<TpmLiqueurActRegisterDetailRespVo> page, @Param("vo") TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo);

}
