package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 活动预算信息表;实体类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act_budget")
@CrmTable(name = "tpm_liqueur_act_budget",tableNote = "TPM-活动预算信息表")
public class TpmLiqueurActBudgetEntity extends CrmExtEntity<TpmLiqueurActBudgetEntity> {

    /**
     * 活动关联预算编码
     */
    @CrmColumn(name = "act_budget_code", length = 32,note = "活动关联预算编码")
    private String actBudgetCode;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 费用预算编码
     */
    @CrmColumn(name = "fee_budget_code", length = 32,note = "费用预算编码")
    private String feeBudgetCode;

    /**
     * 费用预算控制维度id
     */
    @CrmColumn(name = "control_id", length = 32,note = "费用预算控制维度id")
    private String controlId;

    /**
     * 费用预算类型(字典)
     */
    @CrmColumn(name = "fee_budget_type", length = 32,note = "费用预算类型(字典)")
    private String feeBudgetType;

    /**
     * 季度
     */
    @CrmColumn(name = "budget_quater", length = 32,note = "季度")
    private String budgetQuater;

    /**
     * 年
     */
    @CrmColumn(name = "budget_year", length = 32,note = "年")
    private String budgetYear;

    /**
     * 月
     */
    @CrmColumn(name = "budget_month", length = 32,note = "月")
    private String budgetMonth;
    /**
     * 组织类型
     */
    @CrmColumn(name = "org_type", length = 32,note = "组织类型")
    private String orgType;

    /**
     *  申请金额
     */
    @CrmColumn(name = "apply_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "申请金额")
    private BigDecimal applyAmount;

    /**
     *  可用金额
     */
    @CrmColumn(name = "can_use_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "可用金额")
    private BigDecimal canUseAmount;

    /**
     * 核销金额
     */
    @CrmColumn(name = "audit_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "核销金额")
    private BigDecimal auditAmount;

    /**
     * 审批金额
     */
    @CrmColumn(name = "approve_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "审批金额")
    private BigDecimal approveAmount;

    /**
     * 预算科目编码
     */
    @CrmColumn(name = "budget_subjects_code", length = 32,note = "预算科目编码")
    private String budgetSubjectsCode;
}
