package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author maoshen
 * @date 2021/3/3.
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act")
@CrmTable(name = "tpm_liqueur_act",tableNote = "TPM-酒类活动表")
public class TpmLiqueurActEntity extends CrmExtEntity<TpmLiqueurActEntity>{
    /**
     * 活动类型(活动细类)
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动类型(活动细类)")
    private String fineCode;

    /**
     * 活动名称(细类)
     */
    @CrmColumn(name = "fine_name", length = 60,note = "活动名称(细类)")
    private String fineName;

    /**
     * 销售公司
     */
    @CrmColumn(name = "sale_company", length = 60,note = "销售公司")
    private String saleCompany;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 32,note = "流程编号")
    private String processCode;

    /**
     * 是否允许跨组织
     */
    @CrmColumn(name = "is_cross_org", length = 32,note = "是否允许跨组织")
    private String isCrossOrg;
    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 60,note = "活动名称")
    private String actName;

    /**
     * 审批状态(字典)
     */
    @CrmColumn(name = "approve_status", length = 32,note = "审批状态(字典)")
    private String approveStatus;

    /**
     * 组织
     */
    @CrmColumn(name = "org_code", length = 32,note = "组织")
     private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 60,note = "组织名称")
    private String orgName;
    /**
     * 客户
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户")
    private String customerCode;
    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;
    /**
     * 是否完全核销
     */
    @CrmColumn(name = "is_all_audit", length = 32,note = "是否完全核销")
    private String isAllAudit;

    /**
     * 是否核销
     */
    @CrmColumn(name = "is_audit", length = 32,note = "是否核销")
    private String isAudit;
    /**
     * 开始日期
     */
    @CrmColumn(name = "begin_date", length = 32,note = "开始日期")
    private String beginDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date_second", length = 32,note = "开始时间")
    private String beginDateSecond;

    /**
     * 结束日期
     */
    @CrmColumn(name = "end_date", length = 32,note = "结束日期")
    private String endDate;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date_second", length = 32,note = "结束时间")
    private String endDateSecond;

    /**
     * 工作流key
     */
    @CrmColumn(name = "work_flow_key", length = 32,note = "工作流key")
    private String workFlowKey;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "work_flow_name", length = 60,note = "工作流名称")
    private String workFlowName;

    /**
     * 申请金额
     */
    @CrmColumn(name = "apply_total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "申请金额")
    private BigDecimal applyTotalAmount;

    /**
     * 核销截止日期
     */
    @CrmColumn(name = "allow_audit_end_date", length = 32,note = "核销截止日期")
    private String allowAuditEndDate;

    /**
     * 核销截止时间
     */
    @CrmColumn(name = "allow_audit_end_date_second", length = 32,note = "核销截止时间")
    private String allowAuditEndDateSecond;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

    /**
     * 核销金额
     */
    @CrmColumn(name = "audit_total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "核销金额")
   private BigDecimal auditTotalAmount;

    /**
     * 可用余额
     */
    @CrmColumn(name = "can_use_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "可用余额")
    private BigDecimal canUseAmount;

    /**
     * 审批金额
     */
    @CrmColumn(name = "approve_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "审批金额")
    private BigDecimal approveAmount;

    /**
     * 活动表单编码
     */
    @CrmColumn(name = "cost_form_code", length = 32,note = "活动表单编码")
    private String costFormCode;

    /**
     * 核销表单编码
     */
    @CrmColumn(name = "audit_form_code", length = 32,note = "核销表单编码")
    private String auditFormCode;

    /**
     * 活动登记总金额
     */
    @CrmColumn(name = "register_total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "活动登记总金额")
    private BigDecimal registerTotalAmount;
}

