package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动附件信息;实体类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act_file")
@CrmTable(name = "tpm_liqueur_act_file",tableNote = "TPM-活动附件信息")
public class TpmLiqueurActFileEntity extends CrmExtEntity<TpmLiqueurActFileEntity> {

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 附件地址
     */
    @CrmColumn(name = "file_address", length = 60,note = "附件地址")
    private String fileAddress;

    /**
     * 对象名称
     */
    @CrmColumn(name = "object_name", length = 60,note = "对象名称")
    private String objectName;
}
