package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;

import lombok.experimental.Accessors;

/**
 * 酒类活动附件信息;实体类
 *
 * @author lf
 * @date 2021-03-08 18:33:23
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act_register_detail_attach")
@CrmTable(name = "tpm_liqueur_act_register_detail_attach",tableNote = "TPM-酒类活动登记明细附件信息")
public class TpmLiqueurActRegisterDetailAttachEntity extends CrmExtEntity<TpmLiqueurActRegisterDetailAttachEntity> {

    /**
     * 活动登记单号
     */
    @CrmColumn(name = "act_register_code", length = 32,note = "活动登记单号")
    private String actRegisterCode;
    /**
     * 附加信息编码
     */
    @CrmColumn(name = "attach_code", length = 32,note = "附加信息编码")
    private String attachCode;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 投入类型编码
     */
    @CrmColumn(name = "categories_code", length = 32,note = "投入类型编码")
    private String categoriesCode;

    /**
     * 投入类型名称
     */
    @CrmColumn(name = "categories_name", length = 60,note = "投入类型名称")
    private String categoriesName;

    /**
     * 所属销售公司(字典编码)
     */
    @CrmColumn(name = "owned_sales_company", length = 32,note = "所属销售公司(字典编码)")
    private String ownedSalesCompany;

    /**
     * 所属销售公司(字典名称)
     */
    @CrmColumn(name = "owned_sales_company_name", length = 60,note = "所属销售公司(字典名称)")
    private String ownedSalesCompanyName;

    /**
     * 所属客户(编码)
     */
    @CrmColumn(name = "owned_cus_codes", length = 32,note = "所属客户(编码)")
    private String ownedCusCodes;

    /**
     * 所属客户名称
     */
    @CrmColumn(name = "owned_cus_codes_name", length = 60,note = "所属客户名称")
    private String ownedCusCodesName;

    /**
     * 支付类型
     */
    @CrmColumn(name = "pay_type", length = 32,note = "支付类型")
    private String payType;

    /**
     * 支付方式类型
     */
    @CrmColumn(name = "pay_type_type", length = 32,note = "支付方式类型")
    private String payTypeType;

    /**
     * 支付方式名称
     */
    @CrmColumn(name = "pay_type_name", length = 60,note = "支付方式名称")
    private String payTypeName;

    /**
     * 归属客户编码
     */
    @CrmColumn(name = "attribution_cus_code", length = 32,note = "归属客户编码")
    private String attributionCusCode;

    /**
     * 归属客户名称
     */
    @CrmColumn(name = "attribution_cus_name", length = 60,note = "归属客户名称")
    private String attributionCusName;

    /**
     * 归属季度
     */
    @CrmColumn(name = "attribution_quarter", length = 32,note = "归属季度")
    private String attributionQuarter;

    /**
     * 归属月份
     */
    @CrmColumn(name = "attribution_month", length = 32,note = "归属月份")
    private String attributionMonth;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32,note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 60,note = "产品名称")
    private String productName;

    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32,note = "产品层级编码")
    private String productLevelCode;

    /**
     * 产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 60,note = "产品层级名称")
    private String productLevelName;

    /**
     * 产品类型
     */
    @CrmColumn(name = "product_type", length = 32,note = "产品类型")
    private String productType;

    /**
     * 单位编码
     */
    @CrmColumn(name = "unit", length = 32,note = "单位编码")
    private String unit;

    /**
     * 单位名称
     */
    @CrmColumn(name = "unit_name", length = 60,note = "单位名称")
    private String unitName;

    /**
     * 单价
     */
    @CrmColumn(name = "price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "单价")
    private BigDecimal price;

    /**
     * 申请数量
     */
    @CrmColumn(name = "apply_number",note = "申请数量",mysqlType = "bigint(6)", oracleType = "NUMBER(6,0)")
    private Long applyNumber;

    /**
     * 申请金额
     */
    @CrmColumn(name = "apply_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "申请金额")
    private BigDecimal applyAmount;

    /**
     * 审批数量
     */
    @CrmColumn(name = "approval_number",note = "审批数量",mysqlType = "bigint(6)", oracleType = "NUMBER(6,0)")
    private Long approvalNumber;

    /**
     * 审批金额
     */
    @CrmColumn(name = "approval_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "审批金额")
    private BigDecimal approvalAmount;

    /**
     * 支付人
     */
    @CrmColumn(name = "pay_man", length = 32,note = "支付人")
    private String payMan;

    /**
     * 开户行
     */
    @CrmColumn(name = "account_bank", length = 32,note = "开户行")
    private String accountBank;

    /**
     * 账号
     */
    @CrmColumn(name = "account", length = 32,note = "账号")
    private String account;

}
