package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;

import lombok.experimental.Accessors;

/**
 * 酒类活动明细;实体类
 *
 * @author lf
 * @date 2021-03-08 18:06:17
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act_register_detail")
@CrmTable(name = "tpm_liqueur_act_register_detail",tableNote = "TPM-酒类活动明细")
public class TpmLiqueurActRegisterDetailEntity extends CrmExtEntity<TpmLiqueurActRegisterDetailEntity> {

    /**
     * 活动登记单号
     */
    @CrmColumn(name = "act_register_code", length = 32,note = "活动登记单号")
    private String actRegisterCode;
    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 活动细类名称
     */
    @CrmColumn(name = "act_detail_name", length = 60,note = "活动细类名称")
    private String actDetailName;


    /**
     * 负责人
     */
    @CrmColumn(name = "charge_man", length = 32,note = "负责人")
    private String chargeMan;

    /**
     * 举办单位
     */
    @CrmColumn(name = "organizer", length = 60,note = "举办单位")
    private String organizer;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "终端编码")
    private String terminalCode;

    /**
     * 经销商编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "经销商编码")
    private String customerCode;

    /**
     * 兑付类型
     */
    @CrmColumn(name = "redeem_type", length = 32,note = "兑付类型")
    private String redeemType;

    /**
     * 宴席类型
     */
    @CrmColumn(name = "banquet_type", length = 32,note = "宴席类型")
    private String banquetType;

    /**
     * 区域（组织）
     */
    @CrmColumn(name = "org_code", length = 32,note = "区域（组织）")
    private String orgCode;

    /**
     * 业务（职位）编码
     */
    @CrmColumn(name = "position_code", length = 32,note = "业务（职位）编码")
    private String positionCode;

    /**
     * 红包计划发放目的
     */
    @CrmColumn(name = "red_envelope_plan_purpose", length = 60,note = "红包计划发放目的")
    private String redEnvelopePlanPurpose;

    /**
     * 陈列任务
     */
    @CrmColumn(name = "display_task", length = 60,note = "陈列任务")
    private String displayTask;

    /**
     * 三节团拜对象类型
     */
    @CrmColumn(name = "three_festivals_type", length = 32,note = "三节团拜对象类型")
    private String threeFestivalsType;

    /**
     * 登记（申请金额）
     */
    @CrmColumn(name = "apply_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "登记（申请金额）")
    private BigDecimal applyAmount;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date", length = 32,note = "开始时间")
    private String beginDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date_second", length = 32,note = "开始时间")
    private String beginDateSecond;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date", length = 32,note = "结束时间")
    private String endDate;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date_second", length = 32,note = "结束时间")
    private String endDateSecond;

    /**
     * 是否完全核销
     */
    @CrmColumn(name = "is_all_audit", length = 10,note = "是否完全核销")
    private String isAllAudit;
    /**
     * 是否需要核销
     */
    @CrmColumn(name = "is_audit", length = 10,note = "是否需要核销")
    private String isAudit;
    /**
     * 核销截至日期
     */
    @CrmColumn(name = "allow_audit_end_date", length = 32,note = "核销截至日期")
    private String allowAuditEndDate;
    /**
     * 核销截至日期时间
     */
    @CrmColumn(name = "allow_audit_end_date_second", length = 32,note = "核销截至日期时间")
    private String allowAuditEndDateSecond;

    /**
     * 已核销金额
     */
    @CrmColumn(name = "audit_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "已核销金额")
    private BigDecimal  auditAmount;

    @ApiModelProperty("兑付类型名称")
    @CrmColumn(name = "redeem_type_name", length = 60,note = "兑付类型名称")
    private String redeemTypeName;

    @ApiModelProperty("宴席类型名称")
    @CrmColumn(name = "banquet_type_name", length = 60,note = "宴席类型名称")
    private String banquetTypeName;

    @ApiModelProperty("业务（职位）名称")
    @CrmColumn(name = "position_name", length = 60,note = "业务（职位）名称")
    private String positionName;

    @ApiModelProperty("红包计划发放目的名称")
    @CrmColumn(name = "red_envelope_plan_purpose_name", length = 60,note = "红包计划发放目的名称")
    private String redEnvelopePlanPurposeName;

    @ApiModelProperty("三节团拜对象名称")
    @CrmColumn(name = "three_festivals_type_name", length = 60,note = "三节团拜对象名称")
    private String threeFestivalsTypeName;

    @ApiModelProperty("陈列任务名称")
    @CrmColumn(name = "display_task_name", length = 60,note = "陈列任务名称")
    private String displayTaskName;

    @ApiModelProperty("组织名称")
    @CrmColumn(name = "org_name", length = 60,note = "组织名称")
    private String orgName;

    @ApiModelProperty("经销商名称")
    @CrmColumn(name = "customer_name", length = 60,note = "经销商名称")
    private String customerName;

    @ApiModelProperty("终端名称")
    @CrmColumn(name = "terminal_name", length = 60,note = "终端名称")
    private String terminalName;

    @ApiModelProperty("礼品品项编码")
    @CrmColumn(name = "gift_type", length = 32,note = "礼品品项编码")
    private String giftType;

    @ApiModelProperty("礼品品项名称")
    @CrmColumn(name = "gift_type_name", length = 60,note = "礼品品项名称")
    private String giftTypeName;

    @ApiModelProperty("礼品数量")
    @CrmColumn(name = "git_number", length = 32,note = "礼品数量")
    private String gitNumber;

    @ApiModelProperty("礼品单价")
    @CrmColumn(name = "git_price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "礼品单价")
    private BigDecimal gitPrice;

}
