package com.biz.crm.liqueuract.service;

import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Project crm
 * @PackageName com.biz.crm.act.service.impl
 * @ClassName ActOperateFeeBudgetVo
 * @Author HuangLong
 * @Date 2020/11/6 17:40
 * @Description 活动执行费用预算占用和退回时使用的参数集对象
 */
@Data
@Builder
public class LiqueurActOperateFeeBudgetVo implements Serializable {
    private static final long serialVersionUID = -2841716115553697600L;

    /**
     * key,活动明细编码
     */
    private Map<String, List<TpmLiqueurActBudgetTransactionEntity>> budgetDetailsMap;

    /**
     * 费用预算明细对应的所有费用预算集合
     */
    private List<TpmLiqueurActBudgetEntity> feeBudgetEntities;
    /**
     * key:费用预算编码
     */
    private Map<String, TpmLiqueurActBudgetEntity> feeBudgetMap;

    /**
     * 费用预算对应的所有费用预算控制维度集合
     */
    private List<TpmFeeBudgetControlEntity> feeBudgetControls;

    /**
     * key:控制维度id
     */
    private Map<String, TpmFeeBudgetControlEntity> controlEntityMap;
    /**
     * 活动是否是按比例扣减的费用预算
     */
    private Boolean isRatio;


    /**
     * 需要保存的预算费用明细
     */
    private List<TpmLiqueurActBudgetTransactionEntity> saveFeeBudgetDetails;
    /**
     * 需要更新的费用预算编码集合
     */
    private Set<String> saveFeeBudgetCodes;
    /**
     * 需要更新的费用预算控制维度表数据
     */
    private Set<String> saveFeeBudgetControlIds;


    /**
     * 本次操作的类型
     */
    private FeeBudgetControlOperateTypeEnum typeEnum;

    /**
     * 费用预算明细的业务备注
     */
    private String businessRemark;
    /**
     * 核销审批通过时,活动明细对应的核销明细map
     */
    private Map<String, TpmAuditDetailEntity> actDetailToAuditDetailMap;

    /**
     * 需要退回费用预算的活动明细集合
     */
    private List<TpmActDetailEntity> needRefundActDetails;


    /**
     * 是否是核销退回预算
     */
    private Boolean isAuditRefund;

    /**
     * 预算科目map
     */
    private Map<String, TpmBudgetSubjectsEntity> subjectsEntityMap;


}
