package com.biz.crm.liqueuract.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostDutyOrgReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;

import java.util.List;
import java.util.Map;

/**
 * @author maoshen
 * @date 2021/3/3.
 */
public interface TpmLiqueurActService extends IService<TpmLiqueurActEntity> {
    /**
     * 列表
     * @param tpmLiqueurActReqVo
     * @return
     */
    PageResult<TpmLiqueurActRespVo> findList(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 查看
     * @param id
     * @return
     */
    TpmLiqueurActRespVo query(String id);

    /**
     * 根据 登录 人 和是否选择 跨组织 来 获取组织List
     * @param tpmCostDutyOrgReqVo
     * @return
     */
    List<MdmOrgRespVo> getOrgList(TpmCostDutyOrgReqVo tpmCostDutyOrgReqVo);

    /**
     *据组织 来 获取客户List
     * @param reqVo
     * @return
     */
    List<MdmCustomerMsgRespVo>  getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo reqVo);

    /**
     *
     * @param reqVo
     * @return
     */
    PageResult<TpmFeeBudgetControlRespVo> findBudgetController(TpmLiqueurActReqVo reqVo);

    /**
     * 新增
     * @param tpmLiqueurActReqVo
     */
    void save(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 修改
     * @param tpmLiqueurActReqVo
     */
    void update(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 批量删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 活动关闭
     * @param tpmLiqueurActReqVo
     */
    void closed(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 提交审批
     * @param tpmLiqueurActReqVo
     */
    void approve(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 审批通过
     * @param tpmLiqueurActReqVo
     */
    void approved(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 审批驳回
     * @param tpmLiqueurActReqVo
     */
    void reject(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 流程追回
     * @param tpmLiqueurActReqVo
     */
    void interrupt(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 回调
     * @param activitiCallBackVo
     */
    void activityCallBack(ActivitiCallBackVo activitiCallBackVo);

    /**
     * 活动新增查询责任组织树
     * @param tpmCostDutyOrgReqVo
     * @return
     */
    List<BaseTreeRespVo> getOrgTree(TpmCostDutyOrgReqVo tpmCostDutyOrgReqVo);

    /**
     * 活动管理新增下拉选择活动类型接口
     * @param reqVo
     * @return
     */
    List<TpmCostTypeFineRespVo> getFineList(ActGetCategoriesByBudgetReqVo reqVo);
}
