package com.biz.crm.liqueuract.service.impl;

import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailBudgetMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailBudgetEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailBudgetService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailBudgetRespVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 酒类活动预算使用详情信息;接口实现
 *
 * @author lf
 * @date 2021-03-09 16:15:03
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurActRegisterDetailBudgetServiceExpandImpl")
public class TpmLiqueurActRegisterDetailBudgetServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurActRegisterDetailBudgetMapper, TpmLiqueurActRegisterDetailBudgetEntity> implements ITpmLiqueurActRegisterDetailBudgetService {

    @Resource
    private TpmLiqueurActRegisterDetailBudgetMapper tpmLiqueurActRegisterDetailBudgetMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurActRegisterDetailBudgetRespVo> findList(TpmLiqueurActRegisterDetailBudgetReqVo reqVo){
        Page<TpmLiqueurActRegisterDetailBudgetRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRegisterDetailBudgetRespVo> list = tpmLiqueurActRegisterDetailBudgetMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurActRegisterDetailBudgetRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmLiqueurBudgetUsedDetailRespVo
     */
    @Override
    public TpmLiqueurActRegisterDetailBudgetRespVo query(TpmLiqueurActRegisterDetailBudgetReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmLiqueurActRegisterDetailBudgetReqVo reqVo){
        TpmLiqueurActRegisterDetailBudgetEntity entity = CrmBeanUtil.copy(reqVo,TpmLiqueurActRegisterDetailBudgetEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmLiqueurActRegisterDetailBudgetReqVo reqVo){
        TpmLiqueurActRegisterDetailBudgetEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmLiqueurActRegisterDetailBudgetReqVo reqVo){
        List<TpmLiqueurActRegisterDetailBudgetEntity> tpmLiqueurBudgetUsedDetailEntities = tpmLiqueurActRegisterDetailBudgetMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurBudgetUsedDetailEntities)){
            tpmLiqueurBudgetUsedDetailEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurBudgetUsedDetailEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurActRegisterDetailBudgetReqVo reqVo){
        //设置状态为启用
        List<TpmLiqueurActRegisterDetailBudgetEntity> tpmLiqueurBudgetUsedDetailEntities = tpmLiqueurActRegisterDetailBudgetMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurBudgetUsedDetailEntities)){
            tpmLiqueurBudgetUsedDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurBudgetUsedDetailEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurActRegisterDetailBudgetReqVo reqVo){
        //设置状态为禁用
        List<TpmLiqueurActRegisterDetailBudgetEntity> tpmLiqueurBudgetUsedDetailEntities = tpmLiqueurActRegisterDetailBudgetMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurBudgetUsedDetailEntities)){
                tpmLiqueurBudgetUsedDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurBudgetUsedDetailEntities);
    }
}
