package com.biz.crm.liqueuract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.act.model.*;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.liqueuract.mapper.*;
import com.biz.crm.liqueuract.model.*;
import com.biz.crm.liqueuract.service.*;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.liqueuract.service.impl
 * @ClassName TpmLiqueurActRegisterServiceHelper
 * @Author HuangLong
 * @Date 2021/3/10 13:56
 * @Description TODO
 */
@Slf4j
@Component
public class TpmLiqueurActRegisterServiceHelper extends BaseServiceHelper {
    @Resource
    private TpmLiqueurActBudgetMapper actBudgetMapper;

    @Resource
    private TpmLiqueurActRegisterMapper registerMapper;

    @Resource
    private TpmLiqueurActMapper actMapper;

    @Resource
    private TpmCostTypeCategoriesFineMapper costTypeCategoriesFineMapper;

    @Resource
    private TpmCostTypeCategoriesMapper costTypeCategoriesMapper;

    @Resource
    private TpmLiqueurActRegisterDetailMapper detailMapper;

    @Resource
    private TpmLiqueurActRegisterDetailBudgetMapper detailBudgetMapper;

    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper detailAttachMapper;

    @Autowired
    private ITpmLiqueurActRegisterDetailAttachService detailAttachService;

    @Autowired
    private ITpmLiqueurActRegisterDetailService detailService;

    @Autowired
    private ITpmLiqueurActRegisterDetailBudgetService detailBudgetService;

    @Autowired
    private ITpmLiqueurActBudgetTransactionService actBudgetTransactionService;

    @Resource
    private TpmLiqueurActBudgetTransactionMapper actBudgetTransactionMapper;

    @Autowired
    private TpmLiqueurActBudgetService actBudgetService;

    @Resource
    private TpmCostTypeFineMapper fineMapper;

    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;

    public Map<String, Map<String, String>> getDicts(){
        List<String> dictCodes= Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        dictCodes.add(TpmGlobalDictConstants.ACT_APPROVE_STATUS);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }

    /**
     * 转换列表数据
     * @param list
     */
    public void convertListDate(List<TpmLiqueurActRegisterRespVo> list) {
        if(CollectionUtils.isNotEmpty(list)){
            //获取需要的字典集合
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o->{
                //启用禁用状态
                if(StringUtils.isNotEmpty(o.getEnableStatus())){
                    o.setEnableStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ENABLE_STATUS)).orElse(Maps.newHashMap()).get(o.getEnableStatus()));
                }
                //活动审批状态
                if(StringUtils.isNotEmpty(o.getApproveStatus())){
                    o.setApproveStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ACT_APPROVE_STATUS)).orElse(Maps.newHashMap()).get(o.getApproveStatus()));
                }
            });
        }
    }

    /**
     * 通过活动编码查询活动
     * @param actCode
     * @return
     */
    public TpmLiqueurActEntity findActEntityByCode(String actCode){
        AssertUtils.isNotEmpty(actCode,"活动编码不能为空");
        LambdaQueryWrapper<TpmLiqueurActEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TpmLiqueurActEntity::getActCode,actCode);
        return actMapper.selectOne(wrapper);
    }

    /**
     * 通过活动编码查询活动选定的费用预算
     * @return
     */
    public List<TpmLiqueurActBudgetEntity> findActBudgetByActCode(String actCode){
        AssertUtils.isNotEmpty(actCode,"活动编码不能为空");
        LambdaQueryWrapper<TpmLiqueurActBudgetEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TpmLiqueurActBudgetEntity::getActCode,actCode);
        List<TpmLiqueurActBudgetEntity> tpmLiqueurActBudgetEntities = actBudgetMapper.selectList(wrapper);
        AssertUtils.isNotEmpty(tpmLiqueurActBudgetEntities,"活动:"+actCode+",费用预算数据异常");
        return tpmLiqueurActBudgetEntities;
    }

    /**
     * 通过活动类型(活动细类)编码查询投入类型集合,并返回map(key:投入类型编码)
     * @param fineCode
     * @return
     */
    public Map<String,TpmCostTypeCategoriesEntity> findCategoriesMapByFineCode(String fineCode){
        AssertUtils.isNotEmpty(fineCode,"活动类型(活动细类)不能为空");
        //查到中间表
        LambdaQueryWrapper<TpmCostTypeCategoriesFineEntity> costTypeCategoriesFineWrapper = new LambdaQueryWrapper<>();
        costTypeCategoriesFineWrapper.eq(TpmCostTypeCategoriesFineEntity::getFineCode,fineCode);
        List<TpmCostTypeCategoriesFineEntity> tpmCostTypeCategoriesFineEntities = costTypeCategoriesFineMapper.selectList(costTypeCategoriesFineWrapper);
        //根据中间表查活动大类
        List<String> categoriesCodes = Lists.newArrayList();
        tpmCostTypeCategoriesFineEntities.stream().forEach(o->{
            categoriesCodes.add(o.getCategoriesCode());
        });
        LambdaQueryWrapper<TpmCostTypeCategoriesEntity> costTypeCategoriesWrapper = new LambdaQueryWrapper();
        costTypeCategoriesWrapper.in(TpmCostTypeCategoriesEntity::getCategoriesCode,categoriesCodes);
        List<TpmCostTypeCategoriesEntity> tpmCostTypeCategoriesEntities = costTypeCategoriesMapper.selectList(costTypeCategoriesWrapper);
        //将list转化为map
        Map<String, TpmCostTypeCategoriesEntity> map = tpmCostTypeCategoriesEntities.stream()
                .collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity(),(k1, k2)->k1));
        return map;
    }

    /**
     * 删除数据的校验
     * @param ids
     */
    public void deleteCheck(List<String> ids) {
        //只有待提交的数据可以删除(actType=new)
        //查询符合条件的数据(这里考虑到活动的数据量不大,直接全部查出来操作)
        List<TpmLiqueurActRegisterEntity> entities = registerMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurActRegisterEntity.class).in(TpmLiqueurActRegisterEntity::getId, ids));
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("活动登记编码:[");
        if(CollectionUtils.isNotEmpty(entities)){
            StringBuffer msg = new StringBuffer();
            entities.forEach(o->{
                if(!StringUtils.equals(ActApproveStatusEnum.CREATE.getCode(),o.getApproveStatus())){
                    msg.append(o.getActCode()).append(",");
                }
            });
            if(StringUtils.isNotEmpty(msg.toString())){
                throw new BusinessException(errorMsg.append(msg.toString()).append("],的活动状态不为待提交,不能删除").toString());
            }
        }
    }

//    /**
//     * 活动关闭的校验
//     * @param reqVo
//     * @return
//     */
//    public List<TpmActRespVo> closedCheck(TpmActReqVo reqVo) {
//        //判断状态是否都是审批通过,否则报错提示
//        reqVo.setPageSize(-1);
//        List<TpmActRespVo> list = actMapper.findList(PageUtil.buildPage(1, -1), reqVo);
//        AssertUtils.isNotNull(list,"请选择您需要关闭的数据");
//        StringBuffer errorMsg2 = new StringBuffer();
//        StringBuffer errorMsg1 = new StringBuffer();
//        errorMsg2.append("活动编码:[");
//        errorMsg1.append("活动编码:[");
//        if(CollectionUtils.isNotEmpty(list)){
//            StringBuffer msg = new StringBuffer();
//            StringBuffer msg1 = new StringBuffer();
//            list.forEach(o->{
//                if(!StringUtils.equals(ActApproveStatusEnum.APPROVED.getCode(),o.getApproveStatus())){
//                    msg.append(o.getActCode()).append(",");
//                }
//                if(StringUtils.equals(GlobalWhetherEnum.YES.getCode(),o.getIsAllAudit())){
//                    //如当前活动完全核销状态为“是”，则直接提示“该单据已完全核销，无需关闭”。
//                    msg1.append(o.getActCode()).append(",");
//                }
//            });
//            if(StringUtils.isNotEmpty(msg.toString())){
//                throw new BusinessException(errorMsg2.append(msg.toString()).append("],的活动状态不为审批通过,不能关闭").toString());
//            }
//            if(StringUtils.isNotEmpty(msg1.toString())){
//                throw new BusinessException(errorMsg1.append(msg1.toString()).append("],的活动已完全核销，无需关闭”").toString());
//            }
//        }
//        return list;
//    }
//
//    /**
//     * 通过活动明细集合查询出操作费用预算的必要参数
//     * @param detailEntities
//     * @return
//     */
//    public ActOperateFeeBudgetVo setOperateFeeBudgetVo(List<TpmActDetailEntity> detailEntities){
//        List<String> actDetailCodes=Lists.newArrayList();
//        Set<String> actCodes= Sets.newHashSet();
//        detailEntities.stream().forEach(o->{
//            actDetailCodes.add(o.getActDetailCode());
//            actCodes.add(o.getActCode());
//        });
//        List<TpmFeeBudgetDetailsEntity> budgetDetailsEntities = feeBudgetDetailsMapper.selectList(new LambdaQueryWrapper<TpmFeeBudgetDetailsEntity>().in(TpmFeeBudgetDetailsEntity::getBusinessCode, actCodes).in(TpmFeeBudgetDetailsEntity::getBusinessLineCode, actDetailCodes).eq(TpmFeeBudgetDetailsEntity::getFeeBudgetDetailType, FeeBudgetDetailTypeEnum.USE.getCode()).eq(TpmFeeBudgetDetailsEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
//        Boolean isRatio=Objects.nonNull(budgetDetailsEntities.get(0).getReduceRatio());
//        //转换成map->key=活动编码+活动明细编码
//        Map<String, List<TpmFeeBudgetDetailsEntity>> budgetDetailsMap = Maps.newHashMap();
//        //获取费用预算明细对应的费用预算主表数据集合
//        Set<String> feeBudgetCodes = budgetDetailsEntities.stream().map(TpmFeeBudgetDetailsEntity::getFeeBudgetCode).collect(Collectors.toSet());
//        for (TpmFeeBudgetDetailsEntity o : budgetDetailsEntities){
//            feeBudgetCodes.add(o.getFeeBudgetCode());
//            List<TpmFeeBudgetDetailsEntity> list1 = budgetDetailsMap.get(o.getBusinessCode() + o.getBusinessLineCode());
//            if(CollectionUtils.isEmpty(list1)){
//                list1=Lists.newArrayList();
//            }
//            list1.add(o);
//            budgetDetailsMap.put(o.getBusinessCode() + o.getBusinessLineCode(),list1);
//        }
//        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByCodes(feeBudgetCodes);
//        Set<String> controlIds=Sets.newHashSet();
//        Map<String, TpmFeeBudgetEntity> feeBudgetMap=Maps.newHashMap();
//        //预算科目编码
//        Set<String> subjectsCodes = Sets.newHashSet();
//        for (TpmFeeBudgetEntity o: feeBudgetEntities){
//            controlIds.add(o.getControlId());
//            subjectsCodes.add(o.getBudgetSubjectsCode());
//            feeBudgetMap.put(o.getFeeBudgetCode(),o);
//        }
//        List<TpmFeeBudgetControlEntity> feeBudgetControls = this.findFeeBudgetControls(controlIds);
//        Map<String, TpmFeeBudgetControlEntity> controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
//        Map<String, TpmBudgetSubjectsEntity> subjectsEntityMap = this.findBudgetSubjectsByCodes(subjectsCodes);
//        return ActOperateFeeBudgetVo.builder().budgetDetailsMap(budgetDetailsMap)
//                .controlEntityMap(controlEntityMap)
//                .feeBudgetControls(feeBudgetControls)
//                .feeBudgetEntities(feeBudgetEntities)
//                .isRatio(isRatio)
//                .feeBudgetMap(feeBudgetMap)
//                .saveFeeBudgetCodes(Sets.newHashSet())
//                .saveFeeBudgetControlIds(Sets.newHashSet())
//                .saveFeeBudgetDetails(Lists.newArrayList())
//                .subjectsEntityMap(subjectsEntityMap)
//                .build();
//    }
//    /**
//     * 批量关闭活动,释放费用预算的占用
//     * @param list
//     */
//    public void closedBatch(List<TpmActRespVo> list) {
//        List<String> actCodes = list.stream().map(TpmActRespVo::getActCode).collect(Collectors.toList());
//        //校验通过后,1.获取对应的活动的明细
//        List<TpmActDetailEntity> detailEntities = actDetailMapper.selectList(new LambdaQueryWrapper<TpmActDetailEntity>().in(TpmActDetailEntity::getActCode, actCodes));
//        Map<String, List<TpmActDetailEntity>> actDetailMap = detailEntities.stream().collect(Collectors.groupingBy(TpmActDetailEntity::getActCode));
//        //2.获取活动对应的费用预算使用(type=use)明细
//        ActOperateFeeBudgetVo operateFeeBudgetVo = this.setOperateFeeBudgetVo(detailEntities);
//        operateFeeBudgetVo.setBusinessRemark(FeeBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
//
//        for (TpmActRespVo o : list){
//            if(StringUtils.equals(GlobalWhetherEnum.NO.getCode(),o.getIsAllAudit())){
//                List<TpmActDetailEntity> tpmActDetailEntities = actDetailMap.get(o.getActCode());
//                operateFeeBudgetVo.setNeedRefundActDetails(tpmActDetailEntities);
//                this.calculateRefundBudget(operateFeeBudgetVo);
//            }
//        }
//        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.RETURN);
//        //改变活动的状态为关闭
//        actMapper.updateApprovedStatusByCodes(actCodes,ActApproveStatusEnum.CLOSED.getCode());
//        //更新费用预算的所有数据
//        this.saveFeeBudgetDataInfos(operateFeeBudgetVo);
//    }
//
//    /**
//     * 判断在核销审批通过或者活动关闭时,是否需要退回预算
//     * @param isAuditRefund
//     * @param entity
//     * @return
//     */
//    private Boolean judgeIsNeedRefundBudget(Boolean isAuditRefund,TpmActDetailEntity entity){
//        if(Objects.nonNull(isAuditRefund)&&isAuditRefund){
//            if(StringUtils.equals(GlobalWhetherEnum.YES.getCode(),entity.getIsAllAudit())&&entity.getApplyAmount().compareTo(Optional.ofNullable(entity.getAuditAmount()).orElse(BigDecimal.ZERO))==1){
//                return true;
//            }
//        }else {
//            if(StringUtils.equals(GlobalWhetherEnum.NO.getCode(),entity.getIsAllAudit())&&entity.getApplyAmount().compareTo(Optional.ofNullable(entity.getAuditAmount()).orElse(BigDecimal.ZERO))==1){
//                return true;
//            }
//        }
//        return false;
//    }
//
//    /**
//     * 费用预算退回时,计算退回金额,转换相关数据
//     * @param operateFeeBudgetVo
//     * @return
//     */
//    public ActOperateFeeBudgetVo calculateRefundBudget(ActOperateFeeBudgetVo operateFeeBudgetVo){
//        for (TpmActDetailEntity p : operateFeeBudgetVo.getNeedRefundActDetails()){
//            //一条活动明细对应一条费用预算状态为使用的明细
//            //如果活动明细的状态的状态是已经完全核销,则跳过
//            if(this.judgeIsNeedRefundBudget(operateFeeBudgetVo.getIsAuditRefund(),p)){
//                //需要判断费用预算是按比例扣减的还是按照顺序扣减的
//                //先把预算明细按照扣减顺序倒序排序
//                List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = operateFeeBudgetVo.getBudgetDetailsMap().get(p.getActCode() + p.getActDetailCode()).stream().filter(o->o.getFeeAmount().compareTo(BigDecimal.ZERO)!=0).sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder).reversed()).collect(Collectors.toList());
//                AtomicReference<BigDecimal> refundMoney = new AtomicReference<>(p.getApplyAmount().subtract(Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO)));
//                Map<String,BigDecimal> ratioCanRefundMoneyMap=Maps.newHashMap();
//                if(operateFeeBudgetVo.getIsRatio()){
//                    //所有扣减比例对应的总的可退金额
//                    tpmFeeBudgetDetailsEntities.forEach(t->{
//                        String feebudgetTypeKey = this.getFeebudgetTypeKey(t.getFeeBudgetType(), t.getOrgType());
//                        ratioCanRefundMoneyMap.put(feebudgetTypeKey,refundMoney.get().multiply(t.getReduceRatio()).divide(BigDecimal.valueOf(100)));
//                    });
//                }
//                for(TpmFeeBudgetDetailsEntity r : tpmFeeBudgetDetailsEntities){
//                    BigDecimal canRefundMoney=BigDecimal.ZERO;
//                    BigDecimal maxCanRefund=BigDecimal.ZERO;
//                    if(operateFeeBudgetVo.getIsRatio()){
//                        //按比例扣减  最大可退金额等于活动明细的可退款金额乘以每条预算明细上的扣减比例
//                        String feebudgetTypeKey = this.getFeebudgetTypeKey(r.getFeeBudgetType(), r.getOrgType());
//                        maxCanRefund = ratioCanRefundMoneyMap.get(feebudgetTypeKey);
//                        if(maxCanRefund.compareTo(BigDecimal.ZERO)==0){
//                            continue;
//                        }
//                        if(maxCanRefund.compareTo(r.getFeeAmount().abs())==1){
//                            canRefundMoney=r.getFeeAmount().abs();
//                            refundMoney.set(refundMoney.get().subtract(maxCanRefund));
//                            ratioCanRefundMoneyMap.put(feebudgetTypeKey,maxCanRefund.subtract(r.getFeeAmount().abs()));
//                        }else {
//                            canRefundMoney=maxCanRefund;
//                            ratioCanRefundMoneyMap.put(feebudgetTypeKey,BigDecimal.ZERO);
//                        }
//                    }else {
//                        //按照顺序扣减
//                        if(refundMoney.get().compareTo(BigDecimal.ZERO)==0){
//                            break;
//                        }
//                        maxCanRefund = r.getFeeAmount().abs();
//                        if(refundMoney.get().compareTo(maxCanRefund)==1){
//                            canRefundMoney=maxCanRefund;
//                            refundMoney.set(refundMoney.get().subtract(maxCanRefund));
//                        }else {
//                            canRefundMoney=refundMoney.get();
//                            refundMoney.set(BigDecimal.ZERO);
//                        }
//                    }
//                    TpmFeeBudgetEntity budgetEntity = operateFeeBudgetVo.getFeeBudgetMap().get(r.getFeeBudgetCode());
//                    operateFeeBudgetVo.getSaveFeeBudgetCodes().add(budgetEntity.getFeeBudgetCode());
//                    TpmFeeBudgetControlEntity budgetControlEntity = operateFeeBudgetVo.getControlEntityMap().get(budgetEntity.getControlId());
//                    operateFeeBudgetVo.getSaveFeeBudgetControlIds().add(budgetControlEntity.getId());
//                    //增加费用预算的可用余额
//                    budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(canRefundMoney));
//                    //减少费用预算的已使用金额
//                    budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(canRefundMoney));
//                    //控制维度表的金额增加
//                    budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().add(canRefundMoney));
//                    //生成一条费用预算退回的明细
//                    TpmFeeBudgetDetailsEntity newBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
//                    CrmBeanUtil.copyProperties(r,newBudgetDetailsEntity);
//                    if(Objects.nonNull(operateFeeBudgetVo.getIsAuditRefund())&&operateFeeBudgetVo.getIsAuditRefund()){
//                        TpmAuditDetailEntity auditDetailEntity = operateFeeBudgetVo.getActDetailToAuditDetailMap().get(p.getActDetailCode());
//                        newBudgetDetailsEntity.setBusinessCode(auditDetailEntity.getAuditCode());
//                        newBudgetDetailsEntity.setBusinessLineCode(auditDetailEntity.getAuditDetailCode());
//                    }
//                    newBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
//                    newBudgetDetailsEntity.setYear(budgetEntity.getBudgetYear());
//                    newBudgetDetailsEntity.setMonth(budgetEntity.getBudgetMonth());
//                    newBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
//                    newBudgetDetailsEntity.setFeeAmount(canRefundMoney);
//                    newBudgetDetailsEntity.setAfterAmount(budgetEntity.getCanUseAmount());
//                    newBudgetDetailsEntity.setBeforAmount(budgetEntity.getCanUseAmount().subtract(canRefundMoney));
//                    newBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
//                    newBudgetDetailsEntity.setBusinessRemarks(operateFeeBudgetVo.getBusinessRemark());
//                    //设置公参参数为空
//                    super.setPublicParamsNull(newBudgetDetailsEntity);
//                    operateFeeBudgetVo.getSaveFeeBudgetDetails().add(newBudgetDetailsEntity);
//                }
//            }
//        }
//        return operateFeeBudgetVo;
//    }
//    public void saveFeeBudgetDataInfos(ActOperateFeeBudgetVo vo){
//        //更新费用预算
//        List<TpmFeeBudgetEntity> needSaveBudgets = vo.getFeeBudgetEntities().stream().filter(o -> vo.getSaveFeeBudgetCodes().contains(o.getFeeBudgetCode())).collect(Collectors.toList());
//        if(CollectionUtils.isNotEmpty(needSaveBudgets)){
//            feeBudgetService.updateBatchById(needSaveBudgets);
//        }
//        //保存费用预算明细
//        feeBudgetDetailsService.saveBatch(vo.getSaveFeeBudgetDetails());
//        //保存费用预算控制维度
//        List<TpmFeeBudgetControlEntity> saveBudgetControls = vo.getFeeBudgetControls().stream().filter(o -> vo.getSaveFeeBudgetControlIds().contains(o.getId())).collect(Collectors.toList());
//        if(CollectionUtils.isNotEmpty(saveBudgetControls)){
//            saveBudgetControls.forEach(o->{
//                OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(vo.getTypeEnum()).build();
//                budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
//            });
//        }
//    }
//    /**
//     * 通过控制维度查询费用预算
//     * @param controlIds
//     * @return
//     */
//    public List<TpmFeeBudgetEntity> findFeeBudgetByControlIds(Collection<String> controlIds){
//        List<TpmFeeBudgetEntity> feeBudgetEntities = feeBudgetMapper.selectList(new LambdaQueryWrapper<TpmFeeBudgetEntity>().in(TpmFeeBudgetEntity::getControlId, controlIds).eq(TpmFeeBudgetEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()));
//        return feeBudgetEntities;
//    }
//
//    /**
//     * 提交审批校验
//     * @param tpmActReqVo
//     */
//    public void approveCheck(TpmActReqVo tpmActReqVo) {
//        //活动关闭为单条操作,参数接收为id
//        AssertUtils.isNotEmpty(tpmActReqVo.getId(),"id不能为空");
//        AssertUtils.isNotEmpty(tpmActReqVo.getWorkFlowKey(),"请选择流程");
//        //提交审批的数据审批状态必须为 待提交、审批驳回、流程追回
//        TpmActEntity tpmActEntity = actMapper.selectOne(new LambdaQueryWrapper<TpmActEntity>().eq(TpmActEntity::getId, tpmActReqVo.getId()));
//        //获取可以提交审批的状态
//        Set<String> canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
//        AssertUtils.isTrue(canApproveStatus.contains(tpmActEntity.getApproveStatus()),"仅状态为“待提交、审批驳回、流程追回”的单据可提交审批");
//        tpmActReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
//    }
//
//    /**
//     * 通过编码查询活动大类
//     * @param categoriesCodes
//     * @return
//     */
//    public List<TpmCostTypeCategoriesEntity> findCategoriesEntitiesByCodes(Collection<String> categoriesCodes) {
//        List<TpmCostTypeCategoriesEntity> tpmCostTypeCategoriesEntities = categoriesMapper.selectList(new LambdaQueryWrapper<TpmCostTypeCategoriesEntity>().in(TpmCostTypeCategoriesEntity::getCategoriesCode, categoriesCodes));
//        if(CollectionUtils.isEmpty(tpmCostTypeCategoriesEntities)||CollectionUtils.size(tpmCostTypeCategoriesEntities)!=categoriesCodes.size()){
//            throw new BusinessException("活动大类数据发生变更,请重新新建活动");
//        }
//        return tpmCostTypeCategoriesEntities;
//    }
//    public List<TpmCostTypeFineEntity> findFineEntitiesByCodes(Collection<String> fineCodes){
//        List<TpmCostTypeFineEntity> tpmCostTypeFineEntities = fineMapper.selectList(new LambdaQueryWrapper<TpmCostTypeFineEntity>().in(TpmCostTypeFineEntity::getFineCode, fineCodes));
//        if(CollectionUtils.isEmpty(tpmCostTypeFineEntities)||CollectionUtils.size(tpmCostTypeFineEntities)!=fineCodes.size()){
//            throw new BusinessException("细类数据发生变更,请重新新建活动");
//        }
//        return tpmCostTypeFineEntities;
//    }
//
//    /**
//     * 通过活动大类编码和细类编码查询大类和细类之间关系
//     * @param categoriesCodes
//     * @param fineCodes
//     * @return
//     */
//    public List<TpmCostTypeCategoriesFineEntity> findCategoriesFineEntities(Collection<String> categoriesCodes, Collection<String> fineCodes){
//        List<TpmCostTypeCategoriesFineEntity> tpmCostTypeCategoriesFineEntities = categoriesFineMapper.selectList(new LambdaQueryWrapper<TpmCostTypeCategoriesFineEntity>().in(TpmCostTypeCategoriesFineEntity::getCategoriesCode, categoriesCodes).in(TpmCostTypeCategoriesFineEntity::getFineCode, fineCodes));
//        return tpmCostTypeCategoriesFineEntities;
//    }
//

    /**
     * 保存或更新主表数据
     * @param actRegisterEntity
     * @param reqVo
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public TpmLiqueurActRegisterEntity saveOrUpdateActRegister(TpmLiqueurActRegisterEntity actRegisterEntity,TpmLiqueurActRegisterReqVo reqVo) {
        if(ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            actRegisterEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        }else {
            if(StringUtils.isEmpty(actRegisterEntity.getApproveStatus())){
                actRegisterEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
            }
        }
        if(StringUtils.isNotEmpty(actRegisterEntity.getId())){
            registerMapper.updateById(actRegisterEntity);
        }else {
            registerMapper.insert(actRegisterEntity);
        }
        return actRegisterEntity;
    }

    /**
     * 新增或者修改活动明细关联的预算表数据
     * @param actRegisterDetailBudgetEntities
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveActRegisterBudgets(List<TpmLiqueurActRegisterDetailBudgetEntity> actRegisterDetailBudgetEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if(ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())){
            //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
            detailBudgetMapper.delete(new LambdaQueryWrapper<TpmLiqueurActRegisterDetailBudgetEntity>().eq(TpmLiqueurActRegisterDetailBudgetEntity::getActRegisterCode,reqVo.getActRegisterCode()));
        }
        //赋值预算科目编码
        List<String> controlIds = actRegisterDetailBudgetEntities.stream().map(TpmLiqueurActRegisterDetailBudgetEntity::getControlId).collect(Collectors.toList());
        List<TpmFeeBudgetControlEntity> tpmFeeBudgetControlEntities = feeBudgetControlMapper.selectList(Wrappers.lambdaQuery(TpmFeeBudgetControlEntity.class).in(TpmFeeBudgetControlEntity::getId, controlIds));
        if (CollectionUtils.isNotEmpty(tpmFeeBudgetControlEntities)){
            Map<String, List<TpmFeeBudgetControlEntity>> map = tpmFeeBudgetControlEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetControlEntity::getId));
            for (int i =0 ; i<actRegisterDetailBudgetEntities.size();i++){
                TpmLiqueurActRegisterDetailBudgetEntity o = actRegisterDetailBudgetEntities.get(i);
                o.setExt21(new BigDecimal(i));
                List<TpmFeeBudgetControlEntity> list = map.get(o.getControlId());
                if (CollectionUtils.isNotEmpty(list)){
                    o.setBudgetSubjectsCode(list.get(0).getBudgetSubjectsCode());
                }
            }
        }
        detailBudgetService.saveOrUpdateBatch(actRegisterDetailBudgetEntities);
    }

    /**
     * 新增活动登记明细表数据
     * @param actDetailEntities
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveActRegisterDetails(List<TpmLiqueurActRegisterDetailEntity> actDetailEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if(ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())){
            //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
            List<String> list = actDetailEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmLiqueurActRegisterDetailEntity::getId).collect(Collectors.toList());
            detailMapper.delete(new LambdaQueryWrapper<TpmLiqueurActRegisterDetailEntity>().notIn(CollectionUtils.isNotEmpty(list),TpmLiqueurActRegisterDetailEntity::getId,list).eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode,reqVo.getActRegisterCode()));
        }
        detailService.saveOrUpdateBatch(actDetailEntities);
    }

    /**
     * 保存或者修改活动明细附加信息数据
     * @param attachEntities
     * @param reqVo
     */
    public void saveActRegisterAttaches(List<TpmLiqueurActRegisterDetailAttachEntity> attachEntities,TpmLiqueurActRegisterReqVo reqVo) {
        if(CollectionUtils.isNotEmpty(attachEntities)){
            if(ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())){
                //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
                List<String> list = attachEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmLiqueurActRegisterDetailAttachEntity::getId).collect(Collectors.toList());
                detailAttachMapper.delete(new LambdaQueryWrapper<TpmLiqueurActRegisterDetailAttachEntity>().notIn(CollectionUtils.isNotEmpty(list),TpmLiqueurActRegisterDetailAttachEntity::getId,list).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode,reqVo.getActRegisterCode()));
            }
            detailAttachService.saveOrUpdateBatch(attachEntities);
        }else {
            //由于附加信息不是必填,所以编辑的时候如果没有附加信息了需要删除
            if(StringUtils.isNotEmpty(reqVo.getId())){
                detailAttachMapper.delete(Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailAttachEntity.class).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode,reqVo.getActRegisterCode()));
            }
        }
    }


    /**
     * 保存活动费用预算明细表数据
     * @param transactionEntities
     * @param reqVo
     */
    public void saveActBudgetTransactions(List<TpmLiqueurActBudgetTransactionEntity> transactionEntities,TpmLiqueurActRegisterReqVo reqVo) {
        if(!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        actBudgetTransactionService.saveBatch(transactionEntities);
    }

    /**
     * 保存活动费用预算主表数据
     * @param actBudgetEntities
     * @param reqVo
     */
    public void saveActFeeBudgets(List<TpmLiqueurActBudgetEntity> actBudgetEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if(!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        actBudgetService.updateBatchById(actBudgetEntities);
    }

    /**
     * 活动编辑校验
     * @param reqVo
     */
    public void updateCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(),"活动id不能为空");
        TpmLiqueurActRegisterEntity entity = registerMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurActRegisterEntity>().eq(TpmLiqueurActRegisterEntity::getId, reqVo.getId()));
        AssertUtils.isNotNull(entity, ActException.DATA_NOT_EXIST);
        if(!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())){
            throw new BusinessException("当前活动状态不允许修改操作");
        }
        reqVo.setActRegisterCode(entity.getActRegisterCode());
    }



    /**
     * 提交审批的校验
     * @param reqVo
     */
    public TpmLiqueurActRegisterEntity approveCheck(TpmLiqueurActRegisterReqVo reqVo) {
        //活动关闭为单条操作,参数接收为id
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        AssertUtils.isNotEmpty(reqVo.getWorkFlowKey(),"请选择流程");
        //提交审批的数据审批状态必须为 待提交、审批驳回、流程追回
        TpmLiqueurActRegisterEntity entity = registerMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurActRegisterEntity>().eq(TpmLiqueurActRegisterEntity::getId, reqVo.getId()));
        AssertUtils.isNotNull(entity,"当前活动数据不存在");
        //获取可以提交审批的状态
        Set<String> canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue(canApproveStatus.contains(entity.getApproveStatus()),"仅状态为“待提交、审批驳回、流程追回”的单据可提交审批");
        reqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
        return entity;
    }
    /**
     * 审批驳回的校验
     * @param reqVo
     */
    public TpmLiqueurActRegisterEntity rejectAndInterruptCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        TpmLiqueurActRegisterEntity entity = registerMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurActRegisterEntity>().eq(TpmLiqueurActRegisterEntity::getId, reqVo.getId()));
        if(Objects.isNull(entity)||!StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(),entity.getApproveStatus())){
            return null;
        }
        entity.setApproveStatus(reqVo.getApproveStatus());
        return entity;
    }

    /**
     * 审批通过的校验
     * @param reqVo
     */
    public TpmLiqueurActRegisterEntity approvedCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(),"id不能为空");
        TpmLiqueurActRegisterEntity entity = registerMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurActRegisterEntity>().eq(TpmLiqueurActRegisterEntity::getId, reqVo.getId()));
        AssertUtils.isNotNull(entity,"当前活动数据不存在");
        if(!StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(),entity.getApproveStatus())){
            return null;
        }
        return entity;
    }

    /**
     * 组装提交审批流的参数
     * @param entity
     * @param reqVo
     * @return
     */
    public StartProcessReqVo buildStartProcessData(TpmLiqueurActRegisterEntity entity, TpmLiqueurActRegisterReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmLiqueurActRegisterCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis()+"");
        startProcessReqVo.setBusinessCode(entity.getActCode());
        List<TaActFileReqVo> taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    /**
     * 审批通过
     * @param reqVo
     */
    public void approved(TpmLiqueurActRegisterReqVo reqVo) {
        TpmLiqueurActRegisterEntity registerEntity = this.approvedCheck(reqVo);
        if(Objects.isNull(registerEntity)){
            return;
        }
        //修改活动状态为审批通过
        registerEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        //修改活动明细的核销有效期
        TpmLiqueurActEntity actEntity = actMapper.selectOne(Wrappers.lambdaQuery(TpmLiqueurActEntity.class).eq(TpmLiqueurActEntity::getActCode, registerEntity.getActCode()));
        if(!StringUtils.equals(actEntity.getApproveStatus(),ActApproveStatusEnum.APPROVED.getCode())){
            throw new BusinessException("活动申请状态不为审批通过,活动登记审批通过失败");
        }
        //通过活动关联的活动细类编码,找到活动类型
        TpmCostTypeFineEntity fineEntity = fineMapper.selectOne(Wrappers.lambdaQuery(TpmCostTypeFineEntity.class).eq(TpmCostTypeFineEntity::getFineCode, actEntity.getFineCode()));
        AssertUtils.isNotNull(fineEntity,"活动类型:"+actEntity.getFineCode()+",数据不存在");
        //更新活动明细的核销有效期时间
        String date="";
        try {
            if(Objects.nonNull(fineEntity.getAuditValidity())){
                date = DateUtil.formatAddMonth(actEntity.getEndDate(), DateUtil.DEFAULT_DAY_PATTERN, fineEntity.getAuditValidity());
            }else {
                date= GlobalParam.MAX_DATE;
            }
        } catch (ParseException e) {
            log.error("{}",e);
            throw new BusinessException("活动结束时间格式错误");
        }
        //获取所有的活动明细
        List<TpmLiqueurActRegisterDetailEntity> detailEntities = detailMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailEntity.class).eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, registerEntity.getActRegisterCode()));
        for(TpmLiqueurActRegisterDetailEntity o : detailEntities){
            o.setAllowAuditEndDate(date);
            o.setAllowAuditEndDateSecond(DateUtil.DAY_LATEST_TIME);
            o.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
            o.setIsAudit(GlobalWhetherEnum.YES.getCode());
        }
        detailService.saveOrUpdateBatch(detailEntities);
        registerMapper.updateById(registerEntity);
    }

    /**
     * 审批驳回和终止
     * @param reqVo
     */
    public void rejectAndInterrupt(TpmLiqueurActRegisterReqVo reqVo) {
        TpmLiqueurActRegisterEntity registerEntity = this.rejectAndInterruptCheck(reqVo);
        if(Objects.isNull(registerEntity)){
            return;
        }
        TpmLiqueurActEntity actEntity = actMapper.selectOne(Wrappers.lambdaQuery(TpmLiqueurActEntity.class).eq(TpmLiqueurActEntity::getActCode, registerEntity.getActCode()));
        actEntity.setCanUseAmount(actEntity.getCanUseAmount().add(registerEntity.getTotalAmount()));
        actEntity.setRegisterTotalAmount(actEntity.getRegisterTotalAmount().subtract(registerEntity.getTotalAmount()));
        //审批驳回的时候需要把占用的活动预算还回去
        List<TpmLiqueurActBudgetTransactionEntity> budgetTransactionEntities = actBudgetTransactionMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurActBudgetTransactionEntity.class).eq(TpmLiqueurActBudgetTransactionEntity::getBusinessCode, registerEntity.getActRegisterCode()).eq(TpmLiqueurActBudgetTransactionEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        if(CollectionUtils.isNotEmpty(budgetTransactionEntities)){
            Set<String> actBudgetCodes = budgetTransactionEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toSet());
            //查询到活动预算编码对应的活动预算数据
            List<TpmLiqueurActBudgetEntity> actBudgetEntities = actBudgetMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurActBudgetEntity.class).in(TpmLiqueurActBudgetEntity::getActBudgetCode, actBudgetCodes));
            AssertUtils.isTrue(CollectionUtils.size(actBudgetEntities)==CollectionUtils.size(actBudgetCodes),"活动预算数据异常[活动预算数据丢失]");
            Map<String, TpmLiqueurActBudgetEntity> actBudgetEntityMap = actBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getActBudgetCode, Function.identity()));
            List<TpmLiqueurActBudgetTransactionEntity> newTransactions=Lists.newArrayList();
            for (TpmLiqueurActBudgetTransactionEntity transactionEntity : budgetTransactionEntities) {
                //如果占用的金额为零,不需要生成反向明细
                if(transactionEntity.getFeeAmount().compareTo(BigDecimal.ZERO)!=0){
                    TpmLiqueurActBudgetEntity actBudgetEntity = actBudgetEntityMap.get(transactionEntity.getActBudgetCode());
                    TpmLiqueurActBudgetTransactionEntity newTransaction = CrmBeanUtil.copy(transactionEntity, TpmLiqueurActBudgetTransactionEntity.class);
                    super.setPublicParamsNull(newTransaction);
                    newTransaction.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                    newTransaction.setTransactionTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                    newTransaction.setBusinessType(LiqueurActBudgetBusinessTypeEnum.ACT_REGISTER.getCode());
                    newTransaction.setBusinessRemarks(LiqueurActBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
                    newTransaction.setFeeAmount(newTransaction.getFeeAmount().abs());
                    newTransaction.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().add(transactionEntity.getFeeAmount().abs()));
                    newTransactions.add(newTransaction);
                    transactionEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                }
            }
            newTransactions.addAll(budgetTransactionEntities);
            actBudgetTransactionService.saveOrUpdateBatch(newTransactions);
            actBudgetService.updateBatchById(actBudgetEntities);
        }
        registerMapper.updateById(registerEntity);
        actMapper.updateById(actEntity);
    }

    /**
     * 更新活动主表数据
     * @param actEntity
     * @param reqVo
     */
    public void updateActEntity(TpmLiqueurActEntity actEntity, TpmLiqueurActRegisterReqVo reqVo) {
        if(!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        actEntity.setCanUseAmount(Optional.ofNullable(actEntity.getCanUseAmount()).orElse(BigDecimal.ZERO).subtract(reqVo.getTotalAmount()));
        actEntity.setRegisterTotalAmount(Optional.ofNullable(actEntity.getRegisterTotalAmount()).orElse(BigDecimal.ZERO).add(reqVo.getTotalAmount()));
        actMapper.updateById(actEntity);
    }
}
