package com.biz.crm.liqueuract.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.feebudget.service.impl.TpmFeeBudgetControlServiceImpl;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueuract.mapper.*;
import com.biz.crm.liqueuract.model.*;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.customer.MdmCustomerROrgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.*;
import com.biz.crm.util.*;
import com.github.mustachejava.util.LatchedWriter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.MultiCollectorManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/3/4.
 */
@Slf4j
@Component
public class TpmLiqueurServiceHelper extends BaseServiceHelper {

    @Resource
    private MdmOrgFeign orgFeign;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;

    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
    @Autowired
    private TpmFeeBudgetControlServiceImpl feeBudgetControlService;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;

    @Resource
    private TpmLiqueurAuditMapper auditMapper;

    @Autowired
    private ITpmFeeBudgetService feeBudgetService;

    @Autowired
    private ITpmFeeBudgetDetailsService detailsService;
    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;
    @Resource
    private TpmFeeBudgetMapper feeBudgetMapper;
    @Resource
    private TpmBudgetSubjectsMapper subjectsMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;

    @Resource
    private TpmLiqueurActRegisterMapper liqueurActRegisterMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper registerDetailMapper;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Autowired
    private TpmLiqueurActBudgetService liqueurActBudgetService;
    @Autowired
    private FeeBudgetServiceHelper budgetServiceHelper;
    @Resource
    private TpmLiqueurActFileMapper liqueurActFileMapper;

    @Resource
    private TpmLiqueurActRegisterMapper actRegisterMapper;
    @Resource
    private TpmLiqueurActMapper liqueurActMapper;
    @Autowired
    private ITpmLiqueurActBudgetTransactionService transactionService;

    @Resource
    private TpmLiqueurActBudgetTransactionMapper transactionMapper;

    @Resource
    private TpmLiqueurAuditMapper liqueurAuditMapper;

    @Resource
    private ActServiceHelper serviceHelper;


    public Map<String, Map<String, String>> getDictMaps() {
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.ACT_APPROVE_STATUS);
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        dictCodes.add(TpmGlobalDictConstants.YES_OR_NO);
        dictCodes.add(TpmGlobalDictConstants.OWNED_SALES_COMPANY);
        dictCodes.add(TpmGlobalDictConstants.BUDGET_YEAR);
        dictCodes.add(TpmGlobalDictConstants.BUDGET_MONTH);
        dictCodes.add(TpmGlobalDictConstants.BUDGET_QUATER);
        dictCodes.add(TpmGlobalDictConstants.FEE_BUDGET_TYPE);
        dictCodes.add(TpmGlobalDictConstants.PAY_TYPE);
        dictCodes.add(TpmGlobalDictConstants.CONTROL_TYPE);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }


    /**
     * 列表返回数据
     * @param respVoList
     */
    public void setRespVoData(List<TpmLiqueurActRespVo> respVoList) {
        Map<String,Map<String,String>> dataMaps = this.getDictMaps();
        respVoList.forEach(respVo->{
            if (StringUtils.isNotEmpty(respVo.getApproveStatus())){
                respVo.setApproveStatusName(Optional.ofNullable(dataMaps.get(TpmGlobalDictConstants.ACT_APPROVE_STATUS))
                        .orElse(Maps.newHashMap()).get(respVo.getApproveStatus()));
            }
            if (StringUtils.isNotEmpty(respVo.getEnableStatus())){
                respVo.setEnableStatusName(Optional.ofNullable(dataMaps.get(TpmGlobalDictConstants.ENABLE_STATUS))
                        .orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
            }
            // 设置isAllowRegisterDetail
            this.setIsAllowRegisterDetail(respVo);
        });

    }

    /**
     * 设置isAllowRegisterDetail
     * @param respVo
     */
    private void setIsAllowRegisterDetail(TpmLiqueurActRespVo respVo) {
        if (Optional.ofNullable(respVo.getCanUseAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO)>0
                && StringUtils.equals(respVo.getApproveStatus(),ActApproveStatusEnum.APPROVED.getCode())){
            AssertUtils.isNotEmpty(respVo.getEndDate(),"活动结束时间不能为空");
            String date = DateUtil.formatDate()+" "+DateUtil.formatShortTime();
            if (respVo.getEndDate().compareTo(date) > 0){
                respVo.setIsAllowRegisterDetail(GlobalWhetherEnum.YES.getCode());
                return;
            }
        }
        respVo.setIsAllowRegisterDetail(GlobalWhetherEnum.NO.getCode());
    }


    /**
     * 通过 控制维度 查询预算科目
     * @param subjectBudgetCodes
     * @return
     */

    public List<TpmBudgetSubjectsEntity> getTpmBudgetSubjectsEntities(Set<String> subjectBudgetCodes) {
        AssertUtils.isNotEmpty(subjectBudgetCodes,"查询预算科目的code 集合不能为空");
        List<TpmBudgetSubjectsEntity> entities = subjectsMapper.selectList( Wrappers.<TpmBudgetSubjectsEntity>lambdaQuery()
                            .in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode,subjectBudgetCodes));
        if (CollectionUtils.isEmpty(entities)){
            throw new BusinessException("预算科目数据不存在");
        }
        return entities;
    }




    /**
     * 保存活动数据
     * @param liqueurActEntity
     * @param reqVo
     */
    public void saveOrUpdateAct(TpmLiqueurActEntity liqueurActEntity, TpmLiqueurActReqVo reqVo) {
        if(ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            liqueurActEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        }else {
            if(StringUtils.isEmpty(liqueurActEntity.getApproveStatus())){
                liqueurActEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
            }
        }
        if(StringUtils.isNotEmpty(liqueurActEntity.getId())){
            liqueurActMapper.updateById(liqueurActEntity);
        }else {
            liqueurActMapper.insert(liqueurActEntity);
        }
    }

    /**
     * 保存 活动预算 数据
     * @param actBudgetEntities
     * @param reqVo
     */
    public void saveActBudgets(List<TpmLiqueurActBudgetEntity> actBudgetEntities, TpmLiqueurActReqVo reqVo) {
        List<TpmLiqueurActBudgetEntity> actBudgetEntityList =liqueurActBudgetMapper.selectList(Wrappers.<TpmLiqueurActBudgetEntity>lambdaQuery()
                .eq(TpmLiqueurActBudgetEntity::getActCode, reqVo.getActCode()));
        if (CollectionUtils.isEmpty(actBudgetEntityList)){
            liqueurActBudgetService.saveBatch(actBudgetEntities);
            return;
        }
        List<TpmLiqueurActBudgetEntity> needSaveEntities = Lists.newArrayList();
        List<TpmLiqueurActBudgetEntity> needUpdateEntities = Lists.newArrayList();
        actBudgetEntities.forEach(o->{
            actBudgetEntityList.forEach(x->{
                if (o.getFeeBudgetCode().equals(x.getFeeBudgetCode())){
                    x.setApplyAmount(o.getApplyAmount());
                    needUpdateEntities.add(x);
                }else {
                    needSaveEntities.add(o);
                }
            });
        });
        liqueurActBudgetService.saveBatch(needSaveEntities);
        liqueurActBudgetService.updateBatchById(needUpdateEntities);
    }

    /**
     * 保存 附件
     * @param liqueurActFileEntities
     * @param reqVo
     */
    public void saveActFiles(List<TpmLiqueurActFileEntity> liqueurActFileEntities, TpmLiqueurActReqVo reqVo) {
        if(ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())){
            //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
            List<String> list = liqueurActFileEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmLiqueurActFileEntity::getId).collect(Collectors.toList());
            liqueurActFileMapper.delete(new LambdaQueryWrapper<TpmLiqueurActFileEntity>().notIn(CollectionUtils.isNotEmpty(list),TpmLiqueurActFileEntity::getId,list).eq(TpmLiqueurActFileEntity::getActCode,reqVo.getActCode()));
        }
        liqueurActFileEntities.forEach(o->{
            if(StringUtils.isEmpty(o.getId())){
                liqueurActFileMapper.insert(o);
            }else {
                liqueurActFileMapper.updateById(o);
            }
        });
    }

    /**
     * 保存预算
     */
    public void saveFeeBudgets(List<TpmFeeBudgetEntity> feeBudgetEntities, TpmLiqueurActReqVo reqVo) {
        if(!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        feeBudgetService.updateBatchById(feeBudgetEntities);
    }

    /**
     * 保存预算控制维度
     * @param feeBudgetControlEntities
     * @param reqVo
     */
    public void saveBudgetController(List<TpmFeeBudgetControlEntity> feeBudgetControlEntities, TpmLiqueurActReqVo reqVo) {
        if(!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        for (TpmFeeBudgetControlEntity o :  feeBudgetControlEntities){
            OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.USE).build();
            budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
        }
    }

    public StartProcessReqVo buildStartProcessData(TpmLiqueurActEntity entity, TpmLiqueurActReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmLiqueurActCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis()+"");
        startProcessReqVo.setBusinessCode(entity.getActCode());
        List<TaActFileReqVo> taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    public void setBudgetData(TpmLiqueurActRespVo actRespVo) {
        List<TpmLiqueurActBudgetEntity> liqueurActBudgetEntities = liqueurActBudgetMapper.selectList(Wrappers.<TpmLiqueurActBudgetEntity>lambdaQuery()
                .eq(TpmLiqueurActBudgetEntity::getActCode,actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty(liqueurActBudgetEntities)){
            List<TpmLiqueurActBudgetRespVo> respVos = CrmBeanUtil.copyList(liqueurActBudgetEntities,TpmLiqueurActBudgetRespVo.class);
            actRespVo.setBudgetVos(respVos);
            // 设置 控制维度
            Map<String,List<TpmLiqueurActBudgetRespVo>> actBudgetGroupMap = respVos.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetRespVo::getControlId));
            Map<String,BigDecimal> controllerAndAmount = Maps.newHashMap();
            Set<String> idSet = Sets.newHashSet();
            Set<String> budgetCodes = Sets.newHashSet();
            actBudgetGroupMap.keySet().forEach(x->{
                BigDecimal applyAmount = actBudgetGroupMap.get(x).stream().map(TpmLiqueurActBudgetRespVo::getApplyAmount).reduce(BigDecimal::add).get();
                idSet.add(x);
                controllerAndAmount.put(x,applyAmount);
                if (StringUtils.isNotBlank(actBudgetGroupMap.get(x).get(0).getBudgetSubjectsCode())){
                    budgetCodes.add(actBudgetGroupMap.get(x).get(0).getBudgetSubjectsCode());
                }
            });
            Map<String,TpmBudgetSubjectsEntity> subjectsEntityMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(budgetCodes)){
                List<TpmBudgetSubjectsEntity> subjectsEntities = subjectsMapper.selectList(Wrappers.<TpmBudgetSubjectsEntity>lambdaQuery()
                        .in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode,budgetCodes));
                subjectsEntityMap = subjectsEntities.stream()
                        .collect(Collectors.toMap(TpmBudgetSubjectsEntity::getBudgetSubjectsCode,Function.identity()));
            }
            if (CollectionUtils.isEmpty(idSet)){
                return;
            }
            List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(idSet);
            List<TpmFeeBudgetControlEntity> controlEntities = feeBudgetControlMapper.selectBatchIds(idSet);
            List<TpmFeeBudgetRespVo> feeBudgetRespVos = CrmBeanUtil.copyList(feeBudgetEntities,TpmFeeBudgetRespVo.class);
            Map<String,List<TpmFeeBudgetRespVo>> feeBudgetMaps = feeBudgetRespVos.stream()
                    .collect(Collectors.groupingBy(TpmFeeBudgetRespVo::getControlId));
            Map<String,Map<String,String>>  map =this.getDictMaps();
            List<TpmFeeBudgetControlRespVo> controlRespVos = Lists.newArrayList();
            Map<String, TpmBudgetSubjectsEntity> finalSubjectsEntityMap = subjectsEntityMap;
            controlEntities.forEach(x->{
                TpmFeeBudgetControlRespVo vo = CrmBeanUtil.copy(x,TpmFeeBudgetControlRespVo.class);
                if (controllerAndAmount.containsKey(vo.getId())){
                    vo.setApplyAmount(controllerAndAmount.get(x.getId()));
                }
                if (finalSubjectsEntityMap.containsKey(x.getBudgetSubjectsCode())){
                    vo.setBudgetSubjectsName(finalSubjectsEntityMap.get(x.getBudgetSubjectsCode()).getBudgetSubjectsName());
                }
                if(StringUtils.isNotBlank(vo.getBudgetYear())){
                    vo.setBudgetYearName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_YEAR))
                            .orElse(Maps.newHashMap()).get(vo.getBudgetYear()));
                }
                if (StringUtils.isNotBlank(vo.getBudgetMonth())){
                    vo.setBudgetMonthName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_MONTH))
                            .orElse(Maps.newHashMap()).get(vo.getBudgetMonth()));
                }
                if(StringUtils.isNotBlank(vo.getBudgetQuater())){
                    vo.setBudgetQuaterName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_QUATER))
                            .orElse(Maps.newHashMap()).get(vo.getBudgetQuater()));
                }
                if (StringUtils.isNotBlank(vo.getFeeBudgetType())){
                    vo.setFeeBudgetTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.FEE_BUDGET_TYPE))
                            .orElse(Maps.newHashMap()).get(vo.getFeeBudgetType()));
                }
                if (feeBudgetMaps.containsKey(vo.getId())){
                    feeBudgetMaps.get(vo.getId()).forEach(o->{
                        o.setBudgetSubjectsName(vo.getBudgetSubjectsName());
                        if (finalSubjectsEntityMap.containsKey(vo.getBudgetSubjectsCode())){
                            o.setControlType(finalSubjectsEntityMap.get(vo.getBudgetSubjectsCode()).getControlType());
                            if (StringUtils.isNotBlank(o.getControlType())){
                                o.setBudgetSubjectsControlType(Optional.ofNullable(map.get(TpmGlobalDictConstants.CONTROL_TYPE))
                                        .orElse(Maps.newHashMap()).get(o.getControlType()));
                            }
                            if(StringUtils.isNotBlank(o.getBudgetYear())){
                                o.setBudgetYearName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_YEAR))
                                        .orElse(Maps.newHashMap()).get(o.getBudgetYear()));
                            }
                            if (StringUtils.isNotBlank(o.getBudgetMonth())){
                                o.setBudgetMonthName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_MONTH))
                                        .orElse(Maps.newHashMap()).get(o.getBudgetMonth()));
                            }
                            if(StringUtils.isNotBlank(o.getBudgetQuater())){
                                o.setBudgetQuaterName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_QUATER))
                                        .orElse(Maps.newHashMap()).get(o.getBudgetQuater()));
                            }
                        }
                    });
                    vo.setFeeBudgetVos(feeBudgetMaps.get(vo.getId()));
                }
                controlRespVos.add(vo);
            });
            actRespVo.setEditBudgetVos(controlRespVos);
        }
    }

    public void setActFileData(TpmLiqueurActRespVo actRespVo) {
        List<TpmLiqueurActFileEntity> fileEntities = liqueurActFileMapper.selectList(Wrappers.<TpmLiqueurActFileEntity>lambdaQuery()
                .eq(TpmLiqueurActFileEntity::getActCode,actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty(fileEntities)){
            List<TpmLiqueurActFileRespVo> fileRespVos = CrmBeanUtil.copyList(fileEntities,TpmLiqueurActFileRespVo.class);
            actRespVo.setFileVos(fileRespVos);
        }
    }

    /**
     * 编辑检验
     * @param reqVo
     */
    public void checkUpdate(TpmLiqueurActReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(),"活动id不能为空");
        TpmLiqueurActEntity entity = liqueurActMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurActEntity>().eq(TpmLiqueurActEntity::getId, reqVo.getId()));
        AssertUtils.isNotNull(entity, ActException.DATA_NOT_EXIST);
        if(!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())){
            throw new BusinessException("当前活动状态不允许修改操作");
        }
    }

    public TpmLiqueurActEntity saveCheckActStatus(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getActCode(),"活动编码不能为空");
        TpmLiqueurActEntity actEntity = liqueurActMapper.selectOne(Wrappers.<TpmLiqueurActEntity>lambdaQuery()
                .eq(TpmLiqueurActEntity::getActCode,reqVo.getActCode()));
        if (actEntity == null){
            throw new BusinessException("没有活动申请信息");
        }
        if (!actEntity.getApproveStatus().equals(ActApproveStatusEnum.APPROVED.getCode())){
            throw new BusinessException("只有审批通过的活动才可以新增活动明细");
        }
        return actEntity;
    }


    /**
     * 校验组织客户
     * @param reqVo
     */
    public void checkOrgAndCus(TpmLiqueurActReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtils.isNotEmpty(userRedis.getOrgcode())){
            if (CollectionUtils.isNotEmpty(reqVo.getOrgCodeList())){
                /*
                 *填写组织 且 跨组织状态为是  先查所有 parentCode 相同 然后查所有下级
                 *                     否  可选范围为 自身全部下级
                 *   判断 合法依据   parentCode = 当前组织
                 *                  rule 以 当前组织 rule 开头
                 */
                MdmOrgRespVo orgRespVo = ApiResultUtil.objResult(orgFeign.detail(userRedis.getOrgcode()),true);
                MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
                if (StringUtils.equals(reqVo.getIsCrossOrg(), GlobalWhetherEnum.YES.getCode()) && StringUtils.isNotEmpty(orgRespVo.getParentCode())){
                    mdmOrgReqVo.setParentCode(orgRespVo.getParentCode());
//                    List<MdmOrgRespVo> orgRespVos = ApiResultUtil.objResult(orgFeign.findOrgList(mdmOrgReqVo),true);
                    List<MdmOrgRespVo> orgRespVos = OrgUtil.getChildrenOrgListIncludeSelf(orgRespVo.getParentCode());
                    // 可填的
                    Map<String,MdmOrgRespVo> orgCodeMap = orgRespVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode,Function.identity(),(k1,k2)->k1));
                    List<String> orgCodeList = Lists.newArrayList(orgCodeMap.keySet());
                    orgCodeList.retainAll(reqVo.getOrgCodeList());
                    if (orgCodeList.size() != reqVo.getOrgCodeList().size()){
                        reqVo.getOrgCodeList().removeAll(orgCodeList);
                        throw new BusinessException(reqVo.getOrgCodeList()+"该组织不在权限范围");
                    }
                    List<String> orgNameList = Lists.newArrayList();
                    orgCodeList.forEach(o->{
                        orgNameList.add(orgCodeMap.get(o).getOrgName());
                    });
                    reqVo.setOrgName(JsonPropertyUtil.toJsonString(orgNameList));
                }else {
                    mdmOrgReqVo.setOrgCodeList(reqVo.getOrgCodeList());
                    List<MdmOrgRespVo> respVos = ApiResultUtil.objResult(orgFeign.listCondition(mdmOrgReqVo),true);
                    Map<String,MdmOrgRespVo> orgRespVoMap = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity(),(k1, k2)->k1));
                    List<String> orgNameList = Lists.newArrayList();
                    orgRespVoMap.keySet().forEach(o->{
                        if (!StringUtils.startsWith(orgRespVoMap.get(o).getRuleCode(),orgRespVo.getRuleCode())){
                            throw new BusinessException(orgRespVoMap.get(o).getOrgCode()+"该组织不在权限范围");
                        }
                        orgNameList.add(orgRespVoMap.get(o).getOrgName());
                    });
                    reqVo.setOrgName(JsonPropertyUtil.toJsonString(orgNameList));
                }
                reqVo.setOrgCode(JsonPropertyUtil.toJsonString(reqVo.getOrgCodeList()));
                // customerCode 是否在组织之下
                if (CollectionUtils.isNotEmpty(reqVo.getCustomerCodeList())){
                    MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
                    mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                    mdmCustomerOrgSearchReqVo.setOrgCodeList(reqVo.getOrgCodeList());
                    //可选
                    List<MdmCustomerMsgRespVo> customerMsgRespVos =ApiResultUtil
                            .objResult(customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo),true);
                    Map<String,MdmCustomerMsgRespVo> cusMap = customerMsgRespVos.stream()
                            .collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode,Function.identity(),(k1,k2)->k1));
                    List<String> codeList = Lists.newArrayList(cusMap.keySet());
                    codeList.retainAll(reqVo.getCustomerCodeList());
                    if (codeList.size() != reqVo.getCustomerCodeList().size()){
                        reqVo.getCustomerCodeList().removeAll(codeList);
                        throw new BusinessException(reqVo.getCustomerCodeList()+"该客户不在可选范围内");
                    }
                    List<String> cusNameList = Lists.newArrayList();
                    codeList.forEach(o->{
                        cusNameList.add(cusMap.get(o).getCustomerName());
                    });
                    reqVo.setCustomerName(JsonPropertyUtil.toJsonString(cusNameList));
                    reqVo.setCustomerCode(JsonPropertyUtil.toJsonString(reqVo.getCustomerCodeList()));
                }
            }
        }

    }

    /**
     * 校验 预算数据
     * @param reqVo
     */
    public void checkBudgetData(TpmLiqueurActReqVo reqVo) {
        Set<String> controllerIds = reqVo.getBudgetControlVos().stream().map(TpmFeeBudgetControlRespVo::getId).collect(Collectors.toSet());
        List<TpmFeeBudgetControlEntity> controlEntities =this.findControlByIds(controllerIds);
        if (reqVo.getBudgetControlVos().size() != controlEntities.size()){
            throw new BusinessException("预算数据异常,预算不存在");
        }
    }
    /**
     *
     * @param reqVo
     */
    public void checkBudgets(TpmLiqueurActReqVo reqVo) {
        TpmCostTypeFineEntity fineEntity = this.findFineEntity(reqVo.getFineCode());
        reqVo.setFineName(fineEntity.getFineName());
        List<TpmCostTypeCategoriesFineEntity>  categoriesFineEntities = categoriesFineMapper.selectList(Wrappers.<TpmCostTypeCategoriesFineEntity>lambdaQuery()
                .eq(TpmCostTypeCategoriesFineEntity::getFineCode,reqVo.getFineCode()));
        if (CollectionUtils.isEmpty(categoriesFineEntities)){
            throw new BusinessException(reqVo.getFineCode()+"活动类型没有关联投入类型，无法选择预算");
        }
        Set<String> categoriesSets = Sets.newHashSet();
        categoriesSets = categoriesFineEntities.stream().map(TpmCostTypeCategoriesFineEntity::getCategoriesCode).collect(Collectors.toSet());
        List<TpmCostTypeCategoriesEntity> categoriesEntities = tpmCostTypeCategoriesMapper.selectList(Wrappers.<TpmCostTypeCategoriesEntity>lambdaQuery()
                .in(TpmCostTypeCategoriesEntity::getCategoriesCode,categoriesSets));
        if (CollectionUtils.isEmpty(categoriesEntities)){
            throw new BusinessException("关联投入类型不存在,无法获取预算");
        }
        Set<String> budgetSubjectSetByCate = categoriesEntities.stream().map(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(budgetSubjectSetByCate)){
            throw new BusinessException("投入类型数据异常没有预算科目");
        }
        AssertUtils.isNotEmpty(reqVo.getBudgetControlVos(),"请选择预算");
        TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo = new TpmFeeBudgetControlReqVo();
        tpmFeeBudgetControlReqVo.setActBeginDate(reqVo.getBeginDate());
        tpmFeeBudgetControlReqVo.setActEndDate(reqVo.getEndDate());
        List<TpmFeeBudgetControlRespVo> feeBudgetControlRespVoList = feeBudgetControlService.findList(tpmFeeBudgetControlReqVo).getData();
        if (CollectionUtils.isEmpty(feeBudgetControlRespVoList)){
            throw new BusinessException("当前时间段没有可用预算");
        }
        Set<String> budgetSubjectSets = reqVo.getBudgetControlVos().stream().map(TpmFeeBudgetControlRespVo::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (!budgetSubjectSetByCate.containsAll(budgetSubjectSets)){
            throw new BusinessException("预算不支持当前活动类型");
        }
        // 根据组织客户继续选
        if (CollectionUtils.isNotEmpty(reqVo.getOrgCodeList())){
            LambdaQueryWrapper<TpmFeeBudgetControlEntity> wrapper = Wrappers.<TpmFeeBudgetControlEntity>lambdaQuery()
                    .in(TpmFeeBudgetControlEntity::getOrgCode,reqVo.getOrgCodeList());
            if (CollectionUtils.isNotEmpty(reqVo.getCustomerCodeList())){
                wrapper.in(TpmFeeBudgetControlEntity::getCustomerCode,reqVo.getCustomerCodeList());
            }
            List<TpmFeeBudgetControlEntity> feeBudgetControlEntities = feeBudgetControlMapper.selectList(wrapper);
            if (CollectionUtils.isEmpty(feeBudgetControlEntities)){
                throw new BusinessException("根据组织、客户所选预算不存在");
            }
            Set<String> controlIds = feeBudgetControlEntities.stream().map(TpmFeeBudgetControlEntity::getId).collect(Collectors.toSet());
            Map<String,String> reqControlMap = reqVo.getBudgetControlVos().stream().collect(Collectors.toMap(TpmFeeBudgetControlRespVo::getId,TpmFeeBudgetControlRespVo::getFeeBudgetCodes,((k1,k2)->k1)));
            controlIds.retainAll(reqControlMap.keySet());
            if (controlIds.size() != reqControlMap.keySet().size()){
                reqControlMap.keySet().removeAll(controlIds);
                List<String> feeBudgetCodesList = Lists.newArrayList();
                reqControlMap.keySet().forEach(o->{
                    feeBudgetCodesList.add(reqControlMap.get(o));
                });
                throw new BusinessException(feeBudgetCodesList.toString() +"的预算数据信息异常");
            }
        }
    }


    /**
     * 通过 control 表 id 查 control
     * @param ids
     * @return
     */
    public List<TpmFeeBudgetControlEntity> findControlByIds(Set<String> ids) {
        LambdaQueryWrapper<TpmFeeBudgetControlEntity> queryWrapper = new LambdaQueryWrapper<TpmFeeBudgetControlEntity>().in(TpmFeeBudgetControlEntity::getId, ids);
        List<TpmFeeBudgetControlEntity> tpmFeeBudgetControlEntities = feeBudgetControlMapper.selectList(queryWrapper);
        return CollectionUtils.isEmpty(tpmFeeBudgetControlEntities) ? Lists.newArrayList() :tpmFeeBudgetControlEntities;
    }

    /**
     * 通过 control 表 id 查 预算表
     * @param ids
     * @return
     */
    public List<TpmFeeBudgetEntity> findFeeBudgetByControlIds(Set<String> ids) {
        List<TpmFeeBudgetEntity> feeBudgetEntities = feeBudgetMapper.selectList(new LambdaQueryWrapper<TpmFeeBudgetEntity>().in(TpmFeeBudgetEntity::getControlId, ids).eq(TpmFeeBudgetEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()));
        return CollectionUtils.isEmpty(feeBudgetEntities) ? Lists.newArrayList() : feeBudgetEntities;
    }

    /**
     * 审批通过
     * @param tpmLiqueurActReqVo
     */
    public void approved(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        // 检验操作数据
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        if (entity == null){
            return;
        }
        TpmCostTypeFineEntity fineEntity = tpmCostTypeFineMapper.selectOne(Wrappers.<TpmCostTypeFineEntity>lambdaQuery()
                .eq(TpmCostTypeFineEntity::getFineCode,entity.getFineCode()));
        if (fineEntity == null){
            throw new BusinessException("活动类型数据不存在，请重建活动");
        }
        String date="";
        try {
            if(Objects.nonNull(fineEntity.getAuditValidity())){
                date = DateUtil.formatAddMonth(entity.getEndDate(), DateUtil.DEFAULT_DAY_PATTERN, fineEntity.getAuditValidity());
            }else {
                date= GlobalParam.MAX_DATE;
            }
        } catch (ParseException e) {
            log.error("{}",e);
            throw new BusinessException("活动结束时间格式错误");
        }
        entity.setAllowAuditEndDate(date);
        entity.setAllowAuditEndDateSecond(DateUtil.DAY_LATEST_TIME);
        entity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        entity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        entity.setApproveAmount(entity.getApplyTotalAmount());
        entity.setCanUseAmount(entity.getApproveAmount());
        entity.setIsAudit(GlobalWhetherEnum.YES.getCode());
        List<TpmLiqueurActBudgetEntity> liqueurActBudgetEntities = liqueurActBudgetMapper.selectList(Wrappers.<TpmLiqueurActBudgetEntity>lambdaQuery()
                .eq(TpmLiqueurActBudgetEntity::getActCode,entity.getActCode()));
        liqueurActBudgetEntities.forEach(o->{
            o.setApproveAmount(o.getApplyAmount());
            o.setCanUseAmount(o.getApproveAmount());
        });
        List<TpmLiqueurActBudgetTransactionEntity> transactionEntities = Lists.newArrayList();
        liqueurActBudgetEntities.forEach(x->{
            TpmLiqueurActBudgetTransactionEntity transactionEntity = CrmBeanUtil.copy(x,TpmLiqueurActBudgetTransactionEntity.class);
            super.setPublicParamsNull(transactionEntity);
            transactionEntity.setBusinessCode(entity.getActCode());
            transactionEntity.setBusinessName(entity.getActName());
            transactionEntity.setFeeAmount(x.getCanUseAmount());
            transactionEntity.setBusinessType(LiqueurActBudgetBusinessTypeEnum.ACT.getCode());
            transactionEntity.setTransactionType(FeeBudgetDetailTypeEnum.INIT.getCode());
            transactionEntity.setTransactionTypeName(FeeBudgetDetailTypeEnum.INIT.getDes());
            transactionEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            transactionEntity.setBusinessRemarks(LiqueurActBudgetRemarkEnum.ACT_APPROVED_INIT.getDes());
            transactionEntities.add(transactionEntity);
        });
        transactionService.saveBatch(transactionEntities);
        liqueurActBudgetService.updateBatchById(liqueurActBudgetEntities);
        liqueurActMapper.updateById(entity);
    }

    /**
     * 检验操作数据
     * @param tpmLiqueurActReqVo
     */
    private TpmLiqueurActEntity checkOperatingData(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty(tpmLiqueurActReqVo.getId(), CommonException.IDS_NULL);
        TpmLiqueurActEntity entity = liqueurActMapper.selectById(tpmLiqueurActReqVo.getId());
        if (Objects.isNull(entity)||!StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(),entity.getApproveStatus())){
            return null;
        }
        return entity;
    }

    /**
     * 审批驳回
     * @param tpmLiqueurActReqVo
     */
    public void reject(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity =this.checkOperatingData(tpmLiqueurActReqVo);
        if (entity == null){
            return;
        }
        entity.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
        this.rejectAndInterrupt(entity);
    }

    /**
     * 审批驳回 或流程追回
     * @param entity
     */
    private void rejectAndInterrupt(TpmLiqueurActEntity entity) {

        List<TpmLiqueurActBudgetEntity> actBudgetEntities = liqueurActBudgetMapper.selectList(Wrappers.<TpmLiqueurActBudgetEntity>lambdaQuery()
                .eq(TpmLiqueurActBudgetEntity::getActCode,entity.getActCode()));
        Set<String> controlIds = Sets.newHashSet();
        Map<String, BigDecimal> feeBudgetAmount = Maps.newHashMap();
        actBudgetEntities.forEach(o->{
            feeBudgetAmount.put(o.getFeeBudgetCode(),o.getApplyAmount());
            controlIds.add(o.getControlId());
        });
        // 回退申请时候的预算
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(controlIds);
        List<TpmFeeBudgetControlEntity> feeBudgetControlEntities = this.findControlByIds(controlIds);
        feeBudgetEntities.forEach(x->{
            if (feeBudgetAmount.containsKey(x.getFeeBudgetCode())){
                x.setCanUseAmount(x.getCanUseAmount().add(feeBudgetAmount.get(x.getFeeBudgetCode())));
                x.setUsedAmount(x.getUsedAmount().subtract(feeBudgetAmount.get(x.getFeeBudgetCode())));
            }
        });
        Map<String,List<TpmFeeBudgetEntity>> feeBudgetGroupByControlId = feeBudgetEntities.stream()
                .collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        feeBudgetControlEntities.forEach(y->{
            if (feeBudgetGroupByControlId.containsKey(y.getId())){
                BigDecimal bigDecimal = feeBudgetGroupByControlId.get(y.getId()).stream().map(TpmFeeBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).get();
                y.setCanUseAmount(bigDecimal);
            }
        });
        // 生成details 反向数据
        List<TpmFeeBudgetDetailsEntity> detailsEntities = detailsMapper.selectList(Wrappers.<TpmFeeBudgetDetailsEntity>lambdaQuery()
                .eq(TpmFeeBudgetDetailsEntity :: getBusinessCode, entity.getActCode()));
        List<TpmFeeBudgetDetailsEntity> saveDetailsEntities = Lists.newArrayList();
        detailsEntities.forEach(x->{
           if (Optional.ofNullable(x.getFeeAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) !=0){
               TpmFeeBudgetDetailsEntity detailsEntity = CrmBeanUtil.copy(x,TpmFeeBudgetDetailsEntity.class);
               super.setPublicParamsNull(detailsEntity);
               detailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(detailsEntity.getFeeAmount()));
               detailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
               detailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
               detailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
               detailsEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
               saveDetailsEntities.add(detailsEntity);
           }
        });
        detailsService.saveBatch(saveDetailsEntities);
        liqueurActMapper.updateById(entity);
        feeBudgetService.updateBatchById(feeBudgetEntities);
        feeBudgetControlService.updateBatchById(feeBudgetControlEntities);
    }

    /**
     * 提交审批
     * @param tpmLiqueurActReqVo
     */
    public void approve(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty(tpmLiqueurActReqVo.getId(),CommonException.IDS_NULL);
        AssertUtils.isNotEmpty(tpmLiqueurActReqVo.getWorkFlowKey(),"请选择流程");
        TpmLiqueurActEntity entity = liqueurActMapper.selectById(tpmLiqueurActReqVo.getId());
        if (entity == null){
            throw new BusinessException("操作数据不存在");
        }
        if (!ActApproveStatusEnum.getCanApproveStatus().contains(entity.getApproveStatus())){
            throw new BusinessException("当前数据状态不可提交审批");
        }
        tpmLiqueurActReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
        tpmLiqueurActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
    }

    /**
     * 查询 code 查询 活动细类
     * @param fineCode
     * @return
     */
    public TpmCostTypeFineEntity findFineEntity(String fineCode) {
        return tpmCostTypeFineMapper.selectOne(Wrappers.<TpmCostTypeFineEntity>lambdaQuery()
                .eq(TpmCostTypeFineEntity::getFineCode,fineCode));
    }

    /**
     * 流程追回
     * @param tpmLiqueurActReqVo
     */
    public void interrupt(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        if (entity == null){
            return;
        }
        entity.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        this.rejectAndInterrupt(entity);
    }

    /**
     * 活动关闭
     * @param tpmLiqueurActReqVo
     */
    public List<TpmLiqueurActEntity>  closed(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        List<TpmLiqueurActEntity> entities =this.checkCanClosedData(tpmLiqueurActReqVo);
        if (CollectionUtils.isEmpty(entities)){
            return Lists.newArrayList();
        }
        // 取出 活动的 数据
        Set<String> actCodes = Sets.newHashSet();
        Map<String,BigDecimal> actCanUseAmountMap = Maps.newHashMap();
        entities.forEach(o->{
           actCodes.add(o.getActCode());
           actCanUseAmountMap.put(o.getActCode(),o.getCanUseAmount());
           o.setCanUseAmount(BigDecimal.ZERO);
           o.setApproveStatus(ActApproveStatusEnum.CLOSED.getCode());
        });
        AssertUtils.isNotEmpty(actCodes,"无法获取活动相关明细等信息");
        // 获取活动申请 关联 活动预算
        List<TpmLiqueurActBudgetEntity> actBudgetEntities = liqueurActBudgetMapper
                .selectList(Wrappers.<TpmLiqueurActBudgetEntity>lambdaQuery()
                        .in(TpmLiqueurActBudgetEntity::getActCode,actCodes));
        // 通过 活动 取所有 活动登记主表   活动细类 必须是 审批 通过 且未 完全 核销
        List<TpmLiqueurActRegisterEntity> liqueurActRegisterEntities = actRegisterMapper.selectList(Wrappers.<TpmLiqueurActRegisterEntity>lambdaQuery()
                .in(TpmLiqueurActRegisterEntity::getActCode,actCodes)
                .eq(TpmLiqueurActRegisterEntity::getApproveStatus,ActApproveStatusEnum.APPROVED.getCode()));
        Map<String,List<TpmLiqueurActRegisterEntity>> liqueurActRegisterEntityMap = liqueurActRegisterEntities.stream()
                .collect(Collectors.groupingBy(TpmLiqueurActRegisterEntity::getActCode));
//        List<TpmLiqueurActRegisterEntity> cannotClosedList = actRegisterMapper.selectList(Wrappers.<TpmLiqueurActRegisterEntity>lambdaQuery()
//                .eq(TpmLiqueurActRegisterEntity::getActCode,entity.getActCode())
//                .eq(TpmLiqueurActRegisterEntity::getApproveStatus,ActApproveStatusEnum.APPROVING.getCode()));
//        if (CollectionUtils.isNotEmpty(cannotClosedList)){
//            List<String> exceptionCodes = cannotClosedList.stream()
//                    .map(TpmLiqueurActRegisterEntity::getActRegisterCode).collect(Collectors.toList());
//            throw new BusinessException("活动登记信息code为" +exceptionCodes.toString()+ "的数据为审批中，无法关闭");
//        }

        List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities = detailsMapper.selectList(Wrappers
                .<TpmFeeBudgetDetailsEntity>lambdaQuery().in(TpmFeeBudgetDetailsEntity::getBusinessCode,actCodes));

        Map<String,BigDecimal> noAllAuditAmount= Maps.newHashMap();
        // 获取 活动登记 主表 关联的 活动的登记明细   筛选出 未完全核销的金额
        if (CollectionUtils.isNotEmpty(liqueurActRegisterEntities)){
            List<String> actRegisterCodes = liqueurActRegisterEntities.stream().map(TpmLiqueurActRegisterEntity::getActRegisterCode).collect(Collectors.toList());
            List<TpmLiqueurActRegisterDetailEntity> detailEntities = registerDetailMapper.selectList(Wrappers.<TpmLiqueurActRegisterDetailEntity>lambdaQuery()
                    .in(TpmLiqueurActRegisterDetailEntity::getActRegisterCode,actRegisterCodes));
            List<TpmLiqueurActRegisterDetailEntity> finalDetailEntities = detailEntities.stream()
                    .filter(o-> StringUtils.equals(o.getIsAllAudit(),GlobalWhetherEnum.NO.getCode())).collect(Collectors.toList());
            Map<String,TpmLiqueurActRegisterDetailEntity> finalDetailMap =finalDetailEntities
                    .stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode,Function.identity()));
            // 遍历活动登记明细 获取需要 明细需要退回预算的map(编码,金额） 并设置回退详情 transaction 表
            Set<String> actDetailCodes = Sets.newHashSet();
            finalDetailMap.keySet().forEach(x->{
                TpmLiqueurActRegisterDetailEntity detailEntity = finalDetailMap.get(x);
                actDetailCodes.add(x);
                noAllAuditAmount.put(x,detailEntity.getApplyAmount().subtract(detailEntity.getAuditAmount()));

            });
            List<TpmLiqueurActBudgetTransactionEntity> transactionEntities = transactionMapper
                    .selectList(Wrappers.<TpmLiqueurActBudgetTransactionEntity>lambdaQuery()
                            .in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, actDetailCodes));
            List<TpmLiqueurActBudgetTransactionEntity> budgetTransactionEntities =
                    CrmBeanUtil.copyList(transactionEntities,TpmLiqueurActBudgetTransactionEntity.class);
            budgetTransactionEntities.forEach(x->{
                super.setPublicParamsNull(x);
                x.setBusinessType(LiqueurActBudgetBusinessTypeEnum.CLOSED.getCode());
                x.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                x.setTransactionTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                x.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_CLOSE_BUDGET.getDes());
                x.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
            this.actClosedSaveData( actCanUseAmountMap,actBudgetEntities, noAllAuditAmount,budgetTransactionEntities,liqueurActRegisterEntityMap,feeBudgetDetailsEntities);
        }
        if (CollectionUtils.isEmpty(liqueurActRegisterEntities)){
            this.actClosed(feeBudgetDetailsEntities,actBudgetEntities);
        }
        return entities;
    }

    private void actClosed(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities,
                           List<TpmLiqueurActBudgetEntity> actBudgetEntities) {
        Set<String> controlIds = Sets.newHashSet();
        actBudgetEntities.forEach(x->{
            controlIds.add(x.getControlId());
            x.setCanUseAmount(BigDecimal.ZERO);
        });
        List<TpmFeeBudgetDetailsEntity> detailsEntities = Lists.newArrayList();
        List<TpmFeeBudgetControlEntity> controlEntities  = this.findControlByIds(controlIds);
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(controlIds);
        Map<String,TpmFeeBudgetEntity> feeBudgetMap = feeBudgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode,Function.identity()));
        feeBudgetDetailsEntities.forEach(x->{
            TpmFeeBudgetDetailsEntity entity = CrmBeanUtil.copy(x,TpmFeeBudgetDetailsEntity.class);
            super.setPublicParamsNull(entity);
            if (feeBudgetMap.containsKey(x.getFeeBudgetCode())){
                TpmFeeBudgetEntity feeBudgetEntity = feeBudgetMap.get(x.getFeeBudgetCode());
                entity.setFeeAmount(BigDecimal.ZERO.subtract(entity.getFeeAmount()));
                entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                entity.setAfterAmount(entity.getBeforAmount().add(entity.getFeeAmount()));
                entity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_CLOSE_BUDGET.getDes());
                entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                this.setBudgetData(feeBudgetMap,entity);
                detailsEntities.add(entity);
            }
        });
        Map<String,List<TpmFeeBudgetEntity>> feeMap = feeBudgetEntities.stream()
                .collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        controlEntities.forEach(y->{
            if (feeMap.containsKey(y.getId())){
                y.setCanUseAmount(feeMap.get(y.getId()).stream().map(TpmFeeBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).get());
            }
        });
        liqueurActBudgetService.updateBatchById(actBudgetEntities);
        detailsService.saveBatch(detailsEntities);
        feeBudgetService.updateBatchById(feeBudgetEntities);
        feeBudgetControlService.updateBatchById(controlEntities);
    }

    /**
     * 活动关闭 保存数据
     * @param actBudgetEntities
     * @param noAllAuditAmount
     * @param
     * @param
     */
    private void actClosedSaveData(Map<String,BigDecimal> actCanUseAmountMap,
                                   List<TpmLiqueurActBudgetEntity> actBudgetEntities,
                                   Map<String, BigDecimal> noAllAuditAmount,
                                   List<TpmLiqueurActBudgetTransactionEntity> budgetTransactionEntities,
                                   Map<String,List<TpmLiqueurActRegisterEntity>> liqueurActRegisterEntityMap,
                                   List<TpmFeeBudgetDetailsEntity> budgetDetails) {
        // budgetTransactionEntities 的反数据;
        // 占用正序，回退倒序

        /*
         * 将tran 按活动登记明细分组
         *        分组之间倒序
         *        根据 每个登记明细退钱
         */
        Map<String,List<TpmLiqueurActBudgetTransactionEntity>> transactionMap = budgetTransactionEntities.stream()
                .collect(Collectors.groupingBy(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode));
        Set<String> controlIds = Sets.newHashSet();
        this.setBackTransaction(noAllAuditAmount, transactionMap, controlIds);

        Map<String,List<TpmLiqueurActBudgetTransactionEntity>> actBudgetTransactionMap =budgetTransactionEntities.stream()
                .collect(Collectors.groupingBy(TpmLiqueurActBudgetTransactionEntity::getBusinessCode));
        // 每条活动登记 回退 多少预算
        Map<String,BigDecimal> registerBigDecimalMap = Maps.newHashMap();
        actBudgetTransactionMap.keySet().forEach(x->{
            BigDecimal bigDecimal = actBudgetTransactionMap.get(x).stream()
                    .map(TpmLiqueurActBudgetTransactionEntity::getFeeAmount).reduce(BigDecimal::add).get();
            registerBigDecimalMap.put(x,bigDecimal);
        });
        // 每条活动需要退的预算
        //Map<String,BigDecimal> actBigDecimalMap = Maps.newHashMap();
        liqueurActRegisterEntityMap.keySet().forEach(x->{
            AtomicReference<BigDecimal> bigDecimal = new AtomicReference<>(BigDecimal.ZERO);
            liqueurActRegisterEntityMap.get(x).forEach(o->{
               if (registerBigDecimalMap.containsKey(o.getActRegisterCode())){
                  bigDecimal.set(bigDecimal.get().add(registerBigDecimalMap.get(o.getActRegisterCode())));
               }
           });
            if (actCanUseAmountMap.containsKey(x)){
                bigDecimal.set(bigDecimal.get().add(actCanUseAmountMap.get(x)));
                actCanUseAmountMap.put(x,bigDecimal.get());         }
        });

        List<TpmFeeBudgetControlEntity> controlEntities =this.findControlByIds(controlIds);
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(controlIds);
        Map<String,TpmFeeBudgetEntity> tpmFeeBudgetEntityMap = feeBudgetEntities.stream()
                .collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode,Function.identity()));
        // 查询 预算 明细 生成反数据
        Map<String,List<TpmFeeBudgetDetailsEntity>> budgetDetailsMap =budgetDetails.stream()
                .collect(Collectors.groupingBy(TpmFeeBudgetDetailsEntity::getBusinessCode));
        List<TpmFeeBudgetDetailsEntity> updateDetailsEntities=this.backBudget(actCanUseAmountMap, tpmFeeBudgetEntityMap, budgetDetailsMap);

        // 回退 预算明细;
        Map<String,List<TpmLiqueurActBudgetEntity>> actBudgetMap = Maps.newHashMap();
        actBudgetEntities.forEach(x->{
            if (actBudgetMap.containsKey(x.getActCode())) {
                actBudgetMap.get(x.getActCode()).add(x);
            }else {
                actBudgetMap.put(x.getActCode(),Lists.newArrayList());
            }
            x.setCanUseAmount(BigDecimal.ZERO);
        });
        Map<String,List<TpmFeeBudgetEntity>> feeMap = feeBudgetEntities.stream()
                .collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        controlEntities.forEach(y->{
            if (feeMap.containsKey(y.getId())){
                y.setCanUseAmount(feeMap.get(y.getId()).stream().map(TpmFeeBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).get());
            }
        });
        feeBudgetControlService.updateBatchById(controlEntities);
        feeBudgetService.updateBatchById(feeBudgetEntities);
        liqueurActBudgetService.updateBatchById(actBudgetEntities);
        // trantion 表 写 数据
        List<TpmLiqueurActBudgetTransactionEntity> transactionEntities = budgetTransactionEntities.stream()
                .filter(o-> o.getFeeAmount() !=null && o.getFeeAmount().compareTo(BigDecimal.ZERO) != 0)
                .collect(Collectors.toList());
        transactionService.saveBatch(transactionEntities);
        log.info(updateDetailsEntities.toString());
        detailsService.saveBatch(updateDetailsEntities);
    }

    /**
     * 设置 关系表
     * @param noAllAuditAmount
     * @param transactionMap
     * @param controlIds
     */
    private void setBackTransaction(Map<String, BigDecimal> noAllAuditAmount, Map<String, List<TpmLiqueurActBudgetTransactionEntity>> transactionMap, Set<String> controlIds) {
        noAllAuditAmount.keySet().forEach(o->{
            if (transactionMap.containsKey(o)){
                // 倒序
                List<TpmLiqueurActBudgetTransactionEntity> transactionEntities = transactionMap.get(o)
                            .stream().sorted(Comparator.comparing(TpmLiqueurActBudgetTransactionEntity::getReduceOrder).reversed())
                            .collect(Collectors.toList());
                // 获取 该组 tran 该回退的总金额
                AtomicReference<BigDecimal> bigDecimal = new AtomicReference<>(noAllAuditAmount.get(o));
                transactionEntities.forEach(x->{
                    if (bigDecimal.get().compareTo(BigDecimal.ZERO) > 0){
                        if (bigDecimal.get().compareTo(BigDecimal.ZERO.subtract(x.getFeeAmount()))>0 ){
                            x.setFeeAmount(BigDecimal.ZERO.subtract(x.getFeeAmount()));
                            bigDecimal.set(bigDecimal.get().add(x.getFeeAmount()));
                        }else {
                            x.setFeeAmount(bigDecimal.get());
                            bigDecimal.set(BigDecimal.ZERO);
                        }
                    }else {
                        x.setFeeAmount(BigDecimal.ZERO);
                    }
                    controlIds.add(x.getControlId());
                });
            }
        });
    }

    /**
     * 回退预算
     * @param actBigDecimalMap
     * @param tpmFeeBudgetEntityMap
     * @param budgetDetailsMap
     */
    private List<TpmFeeBudgetDetailsEntity> backBudget(Map<String, BigDecimal> actBigDecimalMap, Map<String, TpmFeeBudgetEntity> tpmFeeBudgetEntityMap, Map<String, List<TpmFeeBudgetDetailsEntity>> budgetDetailsMap) {
        List<TpmFeeBudgetDetailsEntity> updateDetailsEntities = Lists.newArrayList();
        budgetDetailsMap.keySet().forEach(x->{
            if (actBigDecimalMap.containsKey(x)){
                AtomicReference<BigDecimal> bigDecimal = new AtomicReference<>(actBigDecimalMap.get(x));
                List<TpmFeeBudgetDetailsEntity> detailsEntities = budgetDetailsMap.get(x).stream()
                        .sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder).reversed())
                        .collect(Collectors.toList());
               detailsEntities.forEach(y->{
                   TpmFeeBudgetEntity feeBudgetEntity = tpmFeeBudgetEntityMap.get(y.getFeeBudgetCode());
                   if(bigDecimal.get().compareTo(BigDecimal.ZERO)>0){
                       if (bigDecimal.get().compareTo(BigDecimal.ZERO.subtract(y.getFeeAmount()))>0){
                           TpmFeeBudgetDetailsEntity entity = CrmBeanUtil.copy(y,TpmFeeBudgetDetailsEntity.class);
                           super.setPublicParamsNull(entity);
                           entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                           entity.setFeeAmount(BigDecimal.ZERO.subtract(entity.getFeeAmount()));
                           entity.setAfterAmount(entity.getBeforAmount().add(entity.getFeeAmount()));
                           this.setBudgetData(tpmFeeBudgetEntityMap, entity);
                           updateDetailsEntities.add(entity);
                       }else {
                           TpmFeeBudgetDetailsEntity entity = CrmBeanUtil.copy(y,TpmFeeBudgetDetailsEntity.class);
                           super.setPublicParamsNull(entity);
                           entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                           entity.setFeeAmount(bigDecimal.get());
                           entity.setAfterAmount(entity.getFeeAmount().add(entity.getBeforAmount()));
                           this.setBudgetData(tpmFeeBudgetEntityMap, entity);
                           updateDetailsEntities.add(entity);
                       }
                   }else {
                       TpmFeeBudgetDetailsEntity entity = CrmBeanUtil.copy(y,TpmFeeBudgetDetailsEntity.class);
                       super.setPublicParamsNull(entity);
                       entity.setFeeAmount(BigDecimal.ZERO);
                       entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                       entity.setAfterAmount(feeBudgetEntity.getCanUseAmount());
                       this.setBudgetData(tpmFeeBudgetEntityMap,entity );
                       updateDetailsEntities.add(entity);
                   }
               });
            }else {
                budgetDetailsMap.get(x).forEach(z->{
                    TpmFeeBudgetDetailsEntity entity = CrmBeanUtil.copy(z,TpmFeeBudgetDetailsEntity.class);
                    TpmFeeBudgetEntity feeBudgetEntity = tpmFeeBudgetEntityMap.get(z.getFeeBudgetCode());
                    super.setPublicParamsNull(entity);
                    entity.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                    entity.setFeeAmount(BigDecimal.ZERO.subtract(entity.getFeeAmount()));
                    entity.setAfterAmount(entity.getFeeAmount().add(entity.getBeforAmount()));
                    this.setBudgetData(tpmFeeBudgetEntityMap, entity);
                    updateDetailsEntities.add(entity);
                });
            }
        });
        return updateDetailsEntities;
    }

    /**
     * 设置预算
     * @param tpmFeeBudgetEntityMap
     * @param entity
     */
    private void setBudgetData(Map<String, TpmFeeBudgetEntity> tpmFeeBudgetEntityMap, TpmFeeBudgetDetailsEntity entity) {
        entity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
        entity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
        entity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_CLOSE_BUDGET.getDes());
        entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
        tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode())
                .setUsedAmount(tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode()).getUsedAmount().subtract(entity.getFeeAmount()));
        tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode())
                .setCanUseAmount(tpmFeeBudgetEntityMap.get(entity.getFeeBudgetCode()).getCanUseAmount().add(entity.getFeeAmount()));
    }

    /**
     * 检验 活动 能否关闭
     * @param tpmLiqueurActReqVo
     * @return
     */
    private List<TpmLiqueurActEntity> checkCanClosedData(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty(tpmLiqueurActReqVo.getIds(),CommonException.IDS_NULL);
        List<TpmLiqueurActEntity> entities = liqueurActMapper.selectBatchIds(tpmLiqueurActReqVo.getIds());
        if (CollectionUtils.isEmpty(entities)){
            throw new BusinessException("需要关闭的活动不存在");
        }
        Set<String> cannotClosed = Sets.newHashSet();
        List<TpmLiqueurActEntity> needClosedActs = Lists.newArrayList();
        Set<String> maybeCanClosedCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getApproveStatus(),ActApproveStatusEnum.APPROVED.getCode())){
                needClosedActs.add(o);
                maybeCanClosedCodes.add(o.getActCode());
            }else {
                cannotClosed.add(o.getActCode());
            }
        });
        AssertUtils.isTrue(needClosedActs.size() == entities.size(),"编码为" + cannotClosed.toString() + "的活动不为审批通过，不可以关闭");
        // 如果活动中有 审批中的核销 活动不可关闭
        List<TpmLiqueurAuditEntity> auditEntities = liqueurAuditMapper.selectList(Wrappers.<TpmLiqueurAuditEntity>lambdaQuery()
                .in(TpmLiqueurAuditEntity::getActCode,maybeCanClosedCodes)
                .eq(TpmLiqueurAuditEntity::getApproveStatus,ActApproveStatusEnum.APPROVING.getCode()));
        if (CollectionUtils.isNotEmpty(auditEntities)){
            Set<String> actCodes = auditEntities.stream().map(TpmLiqueurAuditEntity::getActCode).collect(Collectors.toSet());
            throw new BusinessException("活动编码有在审批中的核销申请,活动编码为"+actCodes.toString());
        }
        return needClosedActs;
    }

    /**
     * 保存 预算明细数据
     * @param feeBudgetDetailEntities
     * @param reqVo
     */
    public void saveFeeBudgetDetails(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailEntities, TpmLiqueurActReqVo reqVo) {
        if(!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        detailsService.saveOrUpdateBatch(feeBudgetDetailEntities);
    }

    public void saveTransaction(TpmLiqueurActBudgetTransactionEntity transactionEntity, TpmLiqueurActReqVo reqVo) {
        if(!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        transactionService.saveOrUpdate(transactionEntity);
    }

    /**
     * 转换组织客户数据
     * @param respVo
     */
    public void convertCusAndOrgData(TpmLiqueurActRespVo respVo) {
        if (StringUtils.isNotBlank(respVo.getOrgCode())) {
            List<String> orgCodes = JSON.parseArray(respVo.getOrgCode(), String.class);
            List<MdmOrgRespVo> orgRespVos = ApiResultUtil.objResult(orgFeign.detailBatchByOrgCodeList(orgCodes),false);
            if (CollectionUtils.isEmpty(orgRespVos)){
                orgRespVos = Lists.newArrayList();
            }
            respVo.setOrgList(orgRespVos);
        }
        if (StringUtils.isNotBlank(respVo.getCustomerCode())){
            Set<String> customerCodes = Sets.newHashSet(JSON.parseArray(respVo.getCustomerCode(),String.class));
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo=new MdmCustomerMsgReqVo();
            mdmCustomerMsgReqVo.setCustomerCodeList(Lists.newArrayList(customerCodes));
            List<MdmCustomerMsgSelectRespVo> list   = ApiResultUtil.objResult(customerMsgFeign.findCustomerSelectList(mdmCustomerMsgReqVo),true);
            if (CollectionUtils.isEmpty(list)){
                list = Lists.newArrayList();
            }
            respVo.setCustomerList(list);
        }
    }

    public void convertLiqueurActRegisterRespVo(TpmLiqueurActRegisterRespVo respVo){
        //获取需要的字典集合
        Map<String, Map<String, String>> map = this.getDictMaps();
        Set<String> budgetSubjectsCode = Sets.newHashSet();
        respVo.getEditBudgetVos().forEach(o->{
            budgetSubjectsCode.add(o.getBudgetSubjectsCode());
            //年份
            if(StringUtils.isNotEmpty(o.getBudgetYear())){
                o.setBudgetYearName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_YEAR)).orElse(Maps.newHashMap()).get(o.getBudgetYear()));
            }
            //月份
            if(StringUtils.isNotEmpty(o.getBudgetMonth())) {
                o.setBudgetMonthName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_MONTH)).orElse(Maps.newHashMap()).get(o.getBudgetMonth()));
            }
            //季度
            if(StringUtils.isNotEmpty(o.getBudgetQuater())){
                o.setBudgetQuaterName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUDGET_QUATER)).orElse(Maps.newHashMap()).get(o.getBudgetQuater()));
            }
        });
        //以budgetSubjectsCode为key分左右
        Map<String, List<TpmBudgetSubjectsEntity>> collect = subjectsMapper.selectList(Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, budgetSubjectsCode)).stream().collect(Collectors.groupingBy(TpmBudgetSubjectsEntity::getBudgetSubjectsCode));
        //转义预算科目名称
        respVo.getEditBudgetVos().forEach(o->{
            o.setBudgetSubjectsName(collect.get(o.getBudgetSubjectsCode()).get(0).getBudgetSubjectsName());
        });
        //转义payType
//        respVo.getDetailVos().stream().forEach(detail->{
//            detail.getAttachVos().stream().forEach(attach->{
//                //支付类型
//                if(StringUtils.isNotEmpty(attach.getPayType())){
//                    attach.setPayTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.PAY_TYPE)).orElse(Maps.newHashMap()).get(attach.getPayType()));
//                }
//            });
//        });

    }

    public void setAttachPayTypes(List<TpmLiqueurActRegisterDetailAttachRespVo> attachEntityVos){
        Set<String> categoriesCodes = Sets.newHashSet();
        attachEntityVos.stream().forEach(o->{
            categoriesCodes.add(o.getCategoriesCode());
        });
        Map<String,TpmCostTypeCategoriesEntity> categoriesMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(categoriesCodes)){
            Map<String, String> payTypesDictMap = serviceHelper.getPayTypesDict();
            List<TpmCostTypeCategoriesEntity> tpmCostTypeCategoriesEntities = tpmCostTypeCategoriesMapper.selectList(Wrappers.lambdaQuery(TpmCostTypeCategoriesEntity.class).select(TpmCostTypeCategoriesEntity::getCategoriesCode,TpmCostTypeCategoriesEntity::getPayType).in(TpmCostTypeCategoriesEntity::getCategoriesCode, categoriesCodes));
            if (CollectionUtils.isNotEmpty(tpmCostTypeCategoriesEntities)){
                categoriesMap = tpmCostTypeCategoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode,Function.identity()));
            }
            //装配payTypes
            for (TpmLiqueurActRegisterDetailAttachRespVo o : attachEntityVos) {
                TpmCostTypeCategoriesEntity categoriesEntity = categoriesMap.get(o.getCategoriesCode());
                if (!Objects.isNull(categoriesEntity)){
                    List<DictItemVo> dictItemVos = serviceHelper.convertDictList(payTypesDictMap, categoriesEntity.getPayType());
                    o.setPayTypes(dictItemVos);
                }
            }
        }
    }
}
