package com.biz.crm.liqueuract.service.impl.actbuilder;

import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActFileEntity;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurServiceHelper;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/3/5.
 */
public class LiqueurActBuilder  extends BaseServiceHelper implements ActBaseBuilder {
    private TpmLiqueurServiceHelper helper;
    private TpmLiqueurActReqVo reqVo;


    private TpmCostTypeFineEntity fineEntity;
    private List<TpmLiqueurActBudgetReqVo> liqueurActBudgetReqVos;

    private List<TpmFeeBudgetControlEntity> controlEntities = Lists.newArrayList();
    private TpmLiqueurActEntity liqueurActEntity;

    private List<TpmLiqueurActBudgetEntity> liqueurActBudgetEntities =Lists.newArrayList();

    private TpmLiqueurActBudgetTransactionEntity transactionEntity = new TpmLiqueurActBudgetTransactionEntity();

    private List<TpmLiqueurActFileEntity> liqueurActFileEntities = Lists.newArrayList();

    private List<TpmFeeBudgetEntity> feeBudgetEntities = Lists.newArrayList();

    private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailEntities = Lists.newArrayList();

    private Map<String,String> subjectsMap = Maps.newHashMap();
    public LiqueurActBuilder(TpmLiqueurServiceHelper helper, TpmLiqueurActReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static LiqueurActBuilder builder(TpmLiqueurServiceHelper helper, TpmLiqueurActReqVo reqVo) {
        return new LiqueurActBuilder(helper, reqVo);
    }

    /**
     * 组装必要数据
     * @return
     */
    @Override
    public ActBaseBuilder init() {

        if (CollectionUtils.isNotEmpty(reqVo.getBudgetControlVos())){
            // 检验填写金额
            this.initLiqueurData();
        }else {
            throw new BusinessException("请选择活动预算");
        }
        return this;
    }

    /**
     * 校验申请金额
     */
    public void initLiqueurData() {
        Map<String,String> subjectsMap = Maps.newHashMap();
        AssertUtils.isNotEmpty(reqVo.getFineCode(),"活动类型不能为空");
        List<TpmLiqueurActBudgetReqVo> liqueurActBudgetReqVos = Lists.newArrayList();
        Set<BigDecimal> applyAmountSet = Sets.newHashSet();
        Set<String> ids = Sets.newHashSet();
        Set<String> subjectBudgetCodes = Sets.newHashSet();
        reqVo.getBudgetControlVos().forEach(o->{
            if(StringUtils.isBlank(o.getId())){
                throw new BusinessException(o.getFeeBudgetCodes()+"费用预算Id不存在");
            }
            if (ids.contains(o.getId())){
                throw new BusinessException("请勿选择相同的预算");
            }
            ids.add(o.getId());
            subjectBudgetCodes.add(o.getBudgetSubjectsCode());
            AtomicInteger count = new AtomicInteger(1);
            if (o.getApplyAmount() !=null ){
                if (o.getApplyAmount().compareTo(BigDecimal.ZERO)>0){
                    applyAmountSet.add(o.getApplyAmount());
                }
                List<TpmFeeBudgetRespVo> feeBudgetRespVos = o.getFeeBudgetVos().stream()
                        .sorted(Comparator.comparing(TpmFeeBudgetRespVo::getCreateDate)).collect(Collectors.toList());
                AtomicReference<BigDecimal> bigDecimal = new AtomicReference<>(o.getApplyAmount());
                feeBudgetRespVos.forEach(x->{
                    TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = this.setTpmLiqueurActBudgetReqVo(x);
                    liqueurActBudgetReqVo.setApplyAmount(bigDecimal.get());
                    liqueurActBudgetReqVo.setReduceOrder(count.get());
                    liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                    count.getAndIncrement();
                    bigDecimal.set(BigDecimal.ZERO);
                });

            }else {
                List<TpmFeeBudgetRespVo> feeBudgetRespVos = o.getFeeBudgetVos();
                feeBudgetRespVos.forEach(x->{
                    TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = setTpmLiqueurActBudgetReqVo(x);
                    liqueurActBudgetReqVo.setApplyAmount(BigDecimal.ZERO);
                    liqueurActBudgetReqVo.setReduceOrder(count.get());
                    count.getAndIncrement();
                    liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                });
            }
        });
        AssertUtils.isNotEmpty(ids,"所选预算id 不存在");
        //AssertUtils.isTrue(subjectBudgetCodes.size() == ids.size(),"预算的预算科目数据异常");
        List<TpmBudgetSubjectsEntity> subjectsEntities =  helper.getTpmBudgetSubjectsEntities(subjectBudgetCodes);
        subjectsMap = subjectsEntities.stream().collect(Collectors.toMap(TpmBudgetSubjectsEntity::getBudgetSubjectsCode,TpmBudgetSubjectsEntity::getControlType));
        AssertUtils.isTrue(applyAmountSet.size()>0,"至少一条预算申请了金额(大于0)");
        reqVo.setLiqueurActBudgetReqVos(liqueurActBudgetReqVos);
        this.liqueurActBudgetReqVos = reqVo.getLiqueurActBudgetReqVos();
        this.controlEntities = helper.findControlByIds(ids);
        this.feeBudgetEntities = helper.findFeeBudgetByControlIds(ids);
        this.fineEntity = helper.findFineEntity(reqVo.getFineCode());
        this.subjectsMap = subjectsMap;
    }

    /**
     * 将 预算部分信息 赋值给 预算 活动；
     * @param x
     * @return
     */
    private TpmLiqueurActBudgetReqVo setTpmLiqueurActBudgetReqVo(TpmFeeBudgetRespVo x) {
        TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = new TpmLiqueurActBudgetReqVo();
        liqueurActBudgetReqVo.setControlId(x.getControlId());
        liqueurActBudgetReqVo.setFeeBudgetCode(x.getFeeBudgetCode());
        liqueurActBudgetReqVo.setFeeBudgetType(x.getFeeBudgetType());
        liqueurActBudgetReqVo.setOrgType(x.getOrgType());
        liqueurActBudgetReqVo.setBudgetMonth(x.getBudgetMonth());
        liqueurActBudgetReqVo.setBudgetYear(x.getBudgetYear());
        liqueurActBudgetReqVo.setBudgetQuater(x.getBudgetQuater());
        liqueurActBudgetReqVo.setBudgetSubjectsCode(x.getBudgetSubjectsCode());
        return liqueurActBudgetReqVo;
    }
    /**
     * 校验数据
     * @return
     */
    @Override
    public ActBaseBuilder check() {
        this.checkActData();
        helper.checkOrgAndCus(reqVo);
        // 检验预算是否可选
        helper.checkBudgets(reqVo);
        // 校验预算金额是否正确
        helper.checkBudgetData(reqVo);
        this.checkAmount();
        //校验 文件
        return this;
    }

    private void checkAmount() {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())){
            return;
        }
        Map<String,List<TpmFeeBudgetEntity>> feeBudgetMap =feeBudgetEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        Map<String,TpmLiqueurActBudgetReqVo> actBudgetReqVoMap = this.liqueurActBudgetReqVos.stream()
                .collect(Collectors.toMap(TpmLiqueurActBudgetReqVo::getFeeBudgetCode, Function.identity()));
        Set<String> feeBudgetIds = Sets.newHashSet();
        List<TpmFeeBudgetDetailsEntity> feeBudgetDetailEntities = Lists.newArrayList();
        controlEntities.forEach(o->{
            AtomicReference<BigDecimal> bigDecimal = new AtomicReference<>(BigDecimal.ZERO);
            feeBudgetMap.get(o.getId()).forEach(x->{
                Set<String> actBudgetCodes = actBudgetReqVoMap.keySet();
                TpmLiqueurActBudgetReqVo actBudgetReqVo = actBudgetReqVoMap.get(x.getFeeBudgetCode());

                if (!subjectsMap.get(o.getBudgetSubjectsCode()).equals(BudgetSubjectsControlTypeEnum.NON.getCode())){
                    if (actBudgetCodes.contains(x.getFeeBudgetCode())){
                        if (x.getCanUseAmount().compareTo(actBudgetReqVo.getApplyAmount())<0){
                            throw new BusinessException(x.getFeeBudgetCode()+"预算可用余额不足");
                        }

                    }
                }
                x.setCanUseAmount(x.getCanUseAmount().subtract(actBudgetReqVo.getApplyAmount()));
                x.setUsedAmount(x.getUsedAmount().add(actBudgetReqVo.getApplyAmount()));
                feeBudgetIds.add(x.getId());
                bigDecimal.set(bigDecimal.get().add(x.getCanUseAmount()));
                TpmFeeBudgetDetailsEntity detailsEntity = CrmBeanUtil.copy(x,TpmFeeBudgetDetailsEntity.class);
                super.setPublicParamsNull(detailsEntity);
                detailsEntity.setInitAmount(x.getInitAmount());
                detailsEntity.setBeforAmount(x.getCanUseAmount().add(actBudgetReqVo.getApplyAmount()));
                detailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(actBudgetReqVo.getApplyAmount()));
                detailsEntity.setAfterAmount(detailsEntity.getBeforAmount().add(detailsEntity.getFeeAmount()));
                feeBudgetDetailEntities.add(detailsEntity);
            });
            o.setCanUseAmount(bigDecimal.get());
        });
        AssertUtils.isTrue(feeBudgetIds.size() == this.liqueurActBudgetReqVos.size(),"预算数据异常");
        // 预算明细
        this.feeBudgetDetailEntities = feeBudgetDetailEntities;
    }

    /**
     *
     * @param
     */
    private void checkActData() {
        AssertUtils.isNotEmpty(reqVo.getActName(),"请输入活动名称");
        AssertUtils.isNotEmpty(reqVo.getBeginDate(),"请选择活动开始时间");
        if(org.apache.commons.lang3.StringUtils.isEmpty(reqVo.getBeginDateSecond())){
            reqVo.setBeginDateSecond(DateUtil.DAY_EARLIEST_TIME);
        }
        AssertUtils.isNotEmpty(reqVo.getEndDate(),"请选择活动结束时间");
        if (org.apache.commons.lang3.StringUtils.isEmpty(reqVo.getEndDateSecond())){
            reqVo.setEndDateSecond(DateUtil.DAY_LATEST_TIME);
        }
        AssertUtils.isTrue(StringUtils.compare(reqVo.getBeginDate()+reqVo.getBeginDateSecond(),
                reqVo.getEndDate()+reqVo.getEndDateSecond()) < 0,"活动开始时间不能大于活动结束时间");
        AssertUtils.isNotEmpty(reqVo.getFineCode(),"请选择活动类型");
        if (StringUtils.isBlank(reqVo.getIsCrossOrg())){
            reqVo.setIsCrossOrg(GlobalWhetherEnum.NO.getCode());
        }
        AssertUtils.isNotEmpty(reqVo.getSaveType(),"活动操作类型不能为空");
        reqVo.setIsCrossOrg(this.fineEntity.getIsSpanOrgBudget());
    }



    @Override
    public ActBaseBuilder convert() {
        this.liqueurActEntity = CrmBeanUtil.copy(reqVo,TpmLiqueurActEntity.class);
        if (StringUtils.isBlank(liqueurActEntity.getActCode())){
            liqueurActEntity.setActCode(CodeUtil.createOneCode(CrmCodeRuleConstants.LIQUEUR_ACT));
        }
        liqueurActEntity.setCanUseAmount(BigDecimal.ZERO);
        liqueurActEntity.setRegisterTotalAmount(BigDecimal.ZERO);
        liqueurActEntity.setApproveAmount(BigDecimal.ZERO);
        liqueurActEntity.setAuditTotalAmount(BigDecimal.ZERO);
        liqueurActEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        liqueurActEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
        liqueurActEntity.setAuditFormCode(this.fineEntity.getAuditFormCode());
        liqueurActEntity.setCostFormCode(this.fineEntity.getCostFormCode());
        BigDecimal amount = this.liqueurActBudgetReqVos.stream().map(TpmLiqueurActBudgetReqVo::getApplyAmount)
                .reduce(BigDecimal.ZERO,BigDecimal::add);
        liqueurActEntity.setApplyTotalAmount(amount);

        // 活动 预算
        this.liqueurActBudgetEntities = CrmBeanUtil.copyList(this.liqueurActBudgetReqVos,TpmLiqueurActBudgetEntity.class);
        this.liqueurActBudgetEntities.forEach(x->{
            x.setActCode(liqueurActEntity.getActCode());
            x.setActBudgetCode(CodeUtil.createOneCode(CrmCodeRuleConstants.LIQUEUR_ACT_BUDGET));
            x.setApproveAmount(BigDecimal.ZERO);
            x.setAuditAmount(BigDecimal.ZERO);
            x.setApproveAmount(BigDecimal.ZERO);
            x.setCanUseAmount(BigDecimal.ZERO);
            super.setPublicParamsNull(x);
        });



        if (CollectionUtils.isNotEmpty(this.feeBudgetDetailEntities)){
            String currentMonth = String.valueOf(DateUtil.getCurrentMonth());
            String currentYear = String.valueOf(DateUtil.getCurrentYear());
            this.feeBudgetDetailEntities.forEach(x->{
                x.setBusinessCode(this.liqueurActEntity.getActCode());
                x.setBusinessName(this.liqueurActEntity.getActName());
                x.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_OCCUPIED_BUDGET.getDes());
                x.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                x.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                x.setYear(currentYear);
                x.setMonth(currentMonth);
                x.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                this.liqueurActBudgetReqVos.forEach(o->{
                    if (x.getFeeBudgetCode().equals(o.getFeeBudgetCode())){
                        x.setReduceOrder(o.getReduceOrder());
                    }
                });
            });
        }

        if (CollectionUtils.isNotEmpty(reqVo.getFileVos())){
            reqVo.getFileVos().forEach(x->{
                x.setActCode(liqueurActEntity.getActCode());
                TpmLiqueurActFileEntity entity = CrmBeanUtil.copy(x,TpmLiqueurActFileEntity.class);
                this.liqueurActFileEntities.add(entity);
            });
        }
        return this;
    }

    @Override
    public TpmLiqueurActEntity save() {

        // 保存数据
        helper.saveOrUpdateAct(liqueurActEntity, reqVo);
        helper.saveActBudgets(liqueurActBudgetEntities,reqVo);
        helper.saveActFiles(liqueurActFileEntities, reqVo);
        helper.saveFeeBudgets(feeBudgetEntities,reqVo);
        helper.saveBudgetController(controlEntities,reqVo);
        helper.saveFeeBudgetDetails(feeBudgetDetailEntities,reqVo);
        return liqueurActEntity;
    }

    @Override
    public TpmLiqueurActEntity update() {
        helper.saveOrUpdateAct(liqueurActEntity, reqVo);
        helper.saveActBudgets(liqueurActBudgetEntities,reqVo);
        helper.saveActFiles(liqueurActFileEntities, reqVo);
        helper.saveFeeBudgets(feeBudgetEntities,reqVo);
        helper.saveBudgetController(controlEntities,reqVo);
        helper.saveFeeBudgetDetails(feeBudgetDetailEntities,reqVo);
        return liqueurActEntity;
    }
}
