package com.biz.crm.sale.controller;

import com.biz.crm.nebular.tpm.sale.req.TpmSalesDataReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesDataRespVo;
import com.biz.crm.sale.service.ITpmSalesDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import java.util.List;

/**
 * 实际销售数据 
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Slf4j
@RestController
@RequestMapping("/tpmsalesdata")
@Api(tags = "实际销售数据 ")
public class TpmSalesDataController {
    @Autowired
    private ITpmSalesDataService tpmSalesDataService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmSalesDataRespVo>> list(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        PageResult<TpmSalesDataRespVo> result=tpmSalesDataService.findList(tpmSalesDataReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmSalesDataRespVo> query(@RequestParam("id") String id) {
        TpmSalesDataRespVo respVo=tpmSalesDataService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        tpmSalesDataService.save(tpmSalesDataReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        tpmSalesDataService.update(tpmSalesDataReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmSalesDataService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo) {
        tpmSalesDataService.enableBatch(tpmSalesDataReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmSalesDataReqVo tpmSalesDataReqVo) {
        tpmSalesDataService.disableBatch(tpmSalesDataReqVo);
        return Result.ok("禁用成功");
    }
}
