package com.biz.crm.sale.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.sale.req.TpmSalesPlansReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesPlansRespVo;
import com.biz.crm.sale.service.ITpmSalesPlansService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 销售计划
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Slf4j
@RestController
@RequestMapping("/tpmsalesplans")
@Api(tags = "销售计划 ")
public class TpmSalesPlansController {
    @Autowired
    private ITpmSalesPlansService tpmSalesPlansService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmSalesPlansRespVo>> list(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo) {
        PageResult<TpmSalesPlansRespVo> result = tpmSalesPlansService.findList(tpmSalesPlansReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmSalesPlansRespVo> query(@RequestParam("id") String id) {
        TpmSalesPlansRespVo respVo = tpmSalesPlansService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo) {
        tpmSalesPlansService.save(tpmSalesPlansReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo) {
        tpmSalesPlansService.update(tpmSalesPlansReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmSalesPlansService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo) {
        tpmSalesPlansService.enableBatch(tpmSalesPlansReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo) {
        tpmSalesPlansService.disableBatch(tpmSalesPlansReqVo);
        return Result.ok("禁用成功");
    }
}
