package com.biz.crm.sale.mapper;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.sale.req.TpmSalesPlansReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesPlansRespVo;
import com.biz.crm.sale.model.TpmSalesPlansEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 销售计划 
 * 
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
public interface TpmSalesPlansMapper extends BaseMapper<TpmSalesPlansEntity> {
    /**
     * 列表
     * @param page
     * @param tpmSalesPlansReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmSalesPlansRespVo> findList(Page<TpmSalesPlansRespVo> page, @Param("vo") TpmSalesPlansReqVo tpmSalesPlansReqVo);

}
