package com.biz.crm.sale.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.sale.req.TpmSalesDataReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesDataRespVo;
import com.biz.crm.sale.model.TpmSalesDataEntity;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.Map;

/**
 * 实际销售数据 接口
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
public interface ITpmSalesDataService extends IService<TpmSalesDataEntity> {

    /**
     * 列表
     * @param tpmSalesDataReqVo
     * @return PageResult<TpmSalesDataRespVo>
     */
    PageResult<TpmSalesDataRespVo> findList(TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 查询
     * @param id
     * @return TpmSalesDataRespVo
     */
    TpmSalesDataRespVo query(String id);

    /**
     * 新增
     * @param tpmSalesDataReqVo
     * @return
     */
    void save(TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 更新
     * @param tpmSalesDataReqVo
     * @return
     */
    void update(TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param tpmSalesDataReqVo
     * @return
     */
    void enableBatch(TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 禁用
     * @param tpmSalesDataReqVo
     * @return
     */
    void disableBatch(TpmSalesDataReqVo tpmSalesDataReqVo);
}

