package com.biz.crm.sale.service;

import com.biz.crm.nebular.tpm.sale.req.TpmSalesPlansReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesPlansRespVo;
import com.biz.crm.sale.model.TpmSalesPlansEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.Map;

/**
 * 销售计划 接口
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
public interface ITpmSalesPlansService extends IService<TpmSalesPlansEntity> {

    /**
     * 列表
     * @param tpmSalesPlansReqVo
     * @return PageResult<TpmSalesPlansRespVo>
     */
    PageResult<TpmSalesPlansRespVo> findList(TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 查询
     * @param id
     * @return TpmSalesPlansRespVo
     */
    TpmSalesPlansRespVo query(String id);

    /**
     * 新增
     * @param tpmSalesPlansReqVo
     * @return
     */
    void save(TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 更新
     * @param tpmSalesPlansReqVo
     * @return
     */
    void update(TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param tpmSalesPlansReqVo
     * @return
     */
    void enableBatch(TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 禁用
     * @param tpmSalesPlansReqVo
     * @return
     */
    void disableBatch(TpmSalesPlansReqVo tpmSalesPlansReqVo);
}

