/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.advancepay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayDetailMapper;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayMapper;
import com.biz.crm.advancepay.model.TpmActAdvancePayDetailEntity;
import com.biz.crm.advancepay.model.TpmActAdvancePayEntity;
import com.biz.crm.advancepay.service.ITpmActAdvancePayDetailService;
import com.biz.crm.advancepay.service.ITpmActAdvancePayService;
import com.biz.crm.advancepay.service.impl.ActAdvancePayServiceHelper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActAdvancePayException;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmActAdvancePayServiceExpandImpl"})
public class TpmActAdvancePayServiceImpl
extends ServiceImpl<TpmActAdvancePayMapper, TpmActAdvancePayEntity>
implements ITpmActAdvancePayService {
    private static final Logger log = LoggerFactory.getLogger(TpmActAdvancePayServiceImpl.class);
    @Resource
    private TpmActAdvancePayMapper tpmActAdvancePayMapper;
    @Autowired
    private ActAdvancePayServiceHelper serviceHelper;
    @Resource
    private TpmActAdvancePayDetailMapper detailMapper;
    @Autowired
    private ITpmActAdvancePayDetailService detailService;

    @Override
    public PageResult<TpmActAdvancePayRespVo> findList(TpmActAdvancePayReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmActAdvancePayRespVo> list = this.tpmActAdvancePayMapper.findList((Page<TpmActAdvancePayRespVo>)page, reqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActAdvancePayRespVo query(TpmActAdvancePayReqVo reqVo) {
        List data = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new TpmActAdvancePayRespVo();
        }
        TpmActAdvancePayRespVo respVo = (TpmActAdvancePayRespVo)data.get(0);
        TpmActAdvancePayDetailReqVo detailReqVo = new TpmActAdvancePayDetailReqVo();
        detailReqVo.setPageSize(Integer.valueOf(-1));
        detailReqVo.setAdvanceCode(respVo.getAdvanceCode());
        List detailRespVos = this.detailService.findList(detailReqVo).getData();
        respVo.setDetailVos(detailRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActAdvancePayReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActAdvancePayEntity.class));
        this.save((Object)entity);
        List detailVos = reqVo.getDetailVos();
        List<TpmActAdvancePayDetailEntity> payDetailEntities = this.convertDetails(detailVos);
        this.detailService.saveBatch(payDetailEntities);
        this.serviceHelper.sendToActivity(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActAdvancePayReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActAdvancePayException.DATA_NOT_EXIST, (String[])new String[0]);
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.CREATE.getCode(), (CharSequence)entity.getApproveStatus()), (String)"\u53ea\u6709\u5f85\u63d0\u4ea4\u7684\u6570\u636e\u5141\u8bb8\u4fee\u6539");
        this.serviceHelper.saveCheck(reqVo);
        TpmActAdvancePayEntity updateEntity = (TpmActAdvancePayEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActAdvancePayEntity.class));
        this.updateById((Object)updateEntity);
        List detailVos = reqVo.getDetailVos();
        List detailIds = detailVos.stream().map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(detailIds)) {
            this.detailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmActAdvancePayDetailEntity::getAdvanceCode, (Object)entity.getAdvanceCode())).notIn(BaseIdEntity::getId, detailIds));
        }
        List<TpmActAdvancePayDetailEntity> payDetailEntities = this.convertDetails(detailVos);
        this.detailService.saveOrUpdateBatch(payDetailEntities);
        this.serviceHelper.sendToActivity(reqVo);
    }

    public List<TpmActAdvancePayDetailEntity> convertDetails(List<TpmActAdvancePayDetailReqVo> detailVos) {
        List<TpmActAdvancePayDetailEntity> payDetailEntities = detailVos.stream().map(o -> {
            TpmActAdvancePayDetailEntity detailEntity = new TpmActAdvancePayDetailEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)detailEntity));
            return detailEntity;
        }).collect(Collectors.toList());
        return payDetailEntities;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmActAdvancePayReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)"\u8bf7\u9009\u60a8\u9700\u8981\u5220\u9664\u7684\u6570\u636e");
        List entities = this.tpmActAdvancePayMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.stream().forEach(o -> AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.CREATE.getCode(), (CharSequence)o.getApproveStatus()), (String)"\u53ea\u6709\u5f85\u63d0\u4ea4\u7684\u6570\u636e\u53ef\u4ee5\u5220\u9664"));
            this.tpmActAdvancePayMapper.deleteBatchIds(reqVo.getIds());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmActAdvancePayReqVo reqVo) {
        List tpmActAdvancePayEntities = this.tpmActAdvancePayMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActAdvancePayEntities)) {
            tpmActAdvancePayEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActAdvancePayEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmActAdvancePayReqVo reqVo) {
        List tpmActAdvancePayEntities = this.tpmActAdvancePayMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActAdvancePayEntities)) {
            tpmActAdvancePayEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActAdvancePayEntities);
    }

    @Override
    public void approve(TpmActAdvancePayReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getProcessCode(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b\u7f16\u53f7");
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActAdvancePayException.DATA_NOT_EXIST, (String[])new String[0]);
        Set canApproveStatus = ActAdvancePayApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue((boolean)canApproveStatus.contains(entity.getApproveStatus()), (String)"\u4ec5\u72b6\u6001\u4e3a\u201c\u5f85\u63d0\u4ea4\u3001\u5ba1\u6279\u9a73\u56de\u3001\u6d41\u7a0b\u8ffd\u56de\u201d\u7684\u5355\u636e\u53ef\u63d0\u4ea4\u5ba1\u6279");
        this.serviceHelper.saveCheck(reqVo);
        TpmActAdvancePayEntity updateEntity = (TpmActAdvancePayEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActAdvancePayEntity.class));
        updateEntity.setApproveStatus(ActAdvancePayApproveStatusEnum.APPROVING.getCode());
        this.updateById((Object)updateEntity);
        List detailVos = reqVo.getDetailVos();
        List<TpmActAdvancePayDetailEntity> payDetailEntities = this.convertDetails(detailVos);
        this.detailService.saveOrUpdateBatch(payDetailEntities);
        this.serviceHelper.sendToActivity(reqVo);
    }
}

