/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.fiscalyear.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.FiscalYearSettingException;
import com.biz.crm.fiscalyear.mapper.TpmFiscalYearSettingMapper;
import com.biz.crm.fiscalyear.model.TpmFiscalYearSettingEntity;
import com.biz.crm.fiscalyear.service.ITpmFiscalYearSettingService;
import com.biz.crm.fiscalyear.service.impl.FiscalYearSettingServiceHelper;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmFiscalYearSettingServiceExpandImpl"})
public class TpmFiscalYearSettingServiceImpl
extends ServiceImpl<TpmFiscalYearSettingMapper, TpmFiscalYearSettingEntity>
implements ITpmFiscalYearSettingService {
    private static final Logger log = LoggerFactory.getLogger(TpmFiscalYearSettingServiceImpl.class);
    @Resource
    private TpmFiscalYearSettingMapper tpmFiscalYearSettingMapper;
    @Autowired
    private FiscalYearSettingServiceHelper serviceHelper;

    @Override
    @CrmLog
    public PageResult<TpmFiscalYearSettingRespVo> findList(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        Page page = new Page((long)tpmFiscalYearSettingReqVo.getPageNum().intValue(), (long)tpmFiscalYearSettingReqVo.getPageSize().intValue());
        List<TpmFiscalYearSettingRespVo> list = this.tpmFiscalYearSettingMapper.findList((Page<TpmFiscalYearSettingRespVo>)page, tpmFiscalYearSettingReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmFiscalYearSettingRespVo query(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        List list = this.findList(tpmFiscalYearSettingReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmFiscalYearSettingRespVo();
        }
        return (TpmFiscalYearSettingRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        this.serviceHelper.saveCheck(tpmFiscalYearSettingReqVo);
        TpmFiscalYearSettingEntity entity = (TpmFiscalYearSettingEntity)((Object)CrmBeanUtil.copy((Object)tpmFiscalYearSettingReqVo, TpmFiscalYearSettingEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        if (StringUtils.isEmpty((CharSequence)tpmFiscalYearSettingReqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmFiscalYearSettingEntity entity = (TpmFiscalYearSettingEntity)((Object)this.getById((Serializable)((Object)tpmFiscalYearSettingReqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException((CrmExceptionType)FiscalYearSettingException.DATA_NOT_EXIST);
        }
        this.serviceHelper.saveCheck(tpmFiscalYearSettingReqVo);
        CrmBeanUtil.copyProperties((Object)tpmFiscalYearSettingReqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)tpmFiscalYearSettingReqVo.getSelectAllFlag())) {
            this.tpmFiscalYearSettingMapper.deleteProductsByParams(tpmFiscalYearSettingReqVo);
        } else {
            AssertUtils.isNotEmpty((Collection)tpmFiscalYearSettingReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            this.tpmFiscalYearSettingMapper.deleteProductsByParams(tpmFiscalYearSettingReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)tpmFiscalYearSettingReqVo.getSelectAllFlag())) {
            TpmFiscalYearSettingEntity entity = new TpmFiscalYearSettingEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.serviceHelper.updateBySelectAll(tpmFiscalYearSettingReqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)tpmFiscalYearSettingReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List mdmProductEntities = this.tpmFiscalYearSettingMapper.selectBatchIds(tpmFiscalYearSettingReqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
                mdmProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            }
            this.updateBatchById(mdmProductEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)tpmFiscalYearSettingReqVo.getSelectAllFlag())) {
            TpmFiscalYearSettingEntity entity = new TpmFiscalYearSettingEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.serviceHelper.updateBySelectAll(tpmFiscalYearSettingReqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)tpmFiscalYearSettingReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List mdmProductEntities = this.tpmFiscalYearSettingMapper.selectBatchIds(tpmFiscalYearSettingReqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
                mdmProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            }
            this.updateBatchById(mdmProductEntities);
        }
    }
}

