/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountInvoiceMapper;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.account.service.ITpmAccountInvoiceService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAccountInvoiceServiceExpandImpl"})
public class TpmAccountInvoiceServiceImpl
extends ServiceImpl<TpmAccountInvoiceMapper, TpmAccountInvoiceEntity>
implements ITpmAccountInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TpmAccountInvoiceServiceImpl.class);
    @Resource
    private TpmAccountInvoiceMapper tpmAccountInvoiceMapper;

    @Override
    public PageResult<TpmAccountInvoiceRespVo> findList(TpmAccountInvoiceReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAccountInvoiceRespVo> list = this.tpmAccountInvoiceMapper.findList((Page<TpmAccountInvoiceRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAccountInvoiceRespVo query(TpmAccountInvoiceReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAccountInvoiceReqVo reqVo) {
        TpmAccountInvoiceEntity entity = (TpmAccountInvoiceEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAccountInvoiceEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAccountInvoiceReqVo reqVo) {
        TpmAccountInvoiceEntity entity = (TpmAccountInvoiceEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmAccountInvoiceReqVo reqVo) {
        List tpmAccountInvoiceEntities = this.tpmAccountInvoiceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountInvoiceEntities)) {
            tpmAccountInvoiceEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmAccountInvoiceEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmAccountInvoiceReqVo reqVo) {
        List tpmAccountInvoiceEntities = this.tpmAccountInvoiceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountInvoiceEntities)) {
            tpmAccountInvoiceEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAccountInvoiceEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmAccountInvoiceReqVo reqVo) {
        List tpmAccountInvoiceEntities = this.tpmAccountInvoiceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountInvoiceEntities)) {
            tpmAccountInvoiceEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAccountInvoiceEntities);
    }
}

