/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActFileMapper;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.act.service.ITpmActFileService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmActFileServiceExpandImpl"})
public class TpmActFileServiceImpl
extends ServiceImpl<TpmActFileMapper, TpmActFileEntity>
implements ITpmActFileService {
    private static final Logger log = LoggerFactory.getLogger(TpmActFileServiceImpl.class);
    @Resource
    private TpmActFileMapper tpmActFileMapper;

    @Override
    public PageResult<TpmActFileRespVo> findList(TpmActFileReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmActFileRespVo> list = this.tpmActFileMapper.findList((Page<TpmActFileRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActFileRespVo query(TpmActFileReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActFileReqVo reqVo) {
        TpmActFileEntity entity = (TpmActFileEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActFileEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActFileReqVo reqVo) {
        TpmActFileEntity entity = (TpmActFileEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmActFileReqVo reqVo) {
        List tpmActFileEntities = this.tpmActFileMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActFileEntities)) {
            tpmActFileEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmActFileEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmActFileReqVo reqVo) {
        List tpmActFileEntities = this.tpmActFileMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActFileEntities)) {
            tpmActFileEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActFileEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmActFileReqVo reqVo) {
        List tpmActFileEntities = this.tpmActFileMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmActFileEntities)) {
            tpmActFileEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActFileEntities);
    }
}

