/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.auditcollectexample.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AuditCollectExampleException;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuditCollectExampleServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(AuditCollectExampleServiceHelper.class);
    @Resource
    private TpmAuditCollectExampleMapper mapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("example_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmAuditCollectExampleRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getExampleType())) {
                    o.setExampleTypeName((String)((Map)Optional.ofNullable(map.get("example_type")).orElse(Maps.newHashMap())).get(o.getExampleType()));
                }
            });
        }
    }

    public LambdaQueryWrapper<TpmAuditCollectExampleEntity> getQueryWrapper(TpmAuditCollectExampleReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getExampleName()), TpmAuditCollectExampleEntity::getExampleName, (Object)reqVo.getExampleName());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getExampleCode()), TpmAuditCollectExampleEntity::getExampleCode, (Object)reqVo.getExampleCode());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getExampleType()), TpmAuditCollectExampleEntity::getExampleType, (Object)reqVo.getExampleType());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus());
        return wrapper;
    }

    public void updateBySelectAll(TpmAuditCollectExampleReqVo reqVo, TpmAuditCollectExampleEntity entity) {
        LambdaQueryWrapper<TpmAuditCollectExampleEntity> queryWrapper = this.getQueryWrapper(reqVo);
        this.mapper.update((Object)entity, (Wrapper)queryWrapper);
    }

    public void saveCheck(TpmAuditCollectExampleReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getExampleCode(), (String)"\u8bf7\u8f93\u5165\u793a\u4f8b\u7f16\u7801");
        AssertUtils.isNotEmpty((String)reqVo.getExampleName(), (String)"\u8bf7\u8f93\u5165\u793a\u4f8b\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getExampleType(), (String)"\u8bf7\u9009\u62e9\u793a\u4f8b\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getEnableStatus(), (String)"\u8bf7\u9009\u62e9\u542f\u7528\u7981\u7528\u72b6\u6001");
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(TpmAuditCollectExampleReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditCollectExampleEntity::getExampleCode, (Object)reqVo.getExampleCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        TpmAuditCollectExampleEntity entity = (TpmAuditCollectExampleEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)AuditCollectExampleException.DATA_DUPLICATE, (String[])new String[0]);
    }
}

