/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAuditDetailServiceExpandImpl"})
public class TpmAuditDetailServiceImpl
extends ServiceImpl<TpmAuditDetailMapper, TpmAuditDetailEntity>
implements ITpmAuditDetailService {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditDetailServiceImpl.class);
    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;

    @Override
    public PageResult<TpmAuditDetailRespVo> findList(TpmAuditDetailReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAuditDetailRespVo> list = this.tpmAuditDetailMapper.findList((Page<TpmAuditDetailRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<TpmAuditDetailRespVo> findAccountAuditDetail(TpmAuditDetailReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAuditDetailRespVo> list = this.tpmAuditDetailMapper.findAccountAuditDetail((Page<TpmAuditDetailRespVo>)page, reqVo);
        list.stream().filter(Objects::nonNull).forEach(o -> o.setFeeAccessible(o.getAuditApplyAmount().subtract(o.getFeeAccessible() == null ? new BigDecimal(0) : o.getFeeAccessible())));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAuditDetailReqVo reqVo) {
        TpmAuditDetailEntity entity = (TpmAuditDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditDetailEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAuditDetailReqVo reqVo) {
        TpmAuditDetailEntity entity = (TpmAuditDetailEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmAuditDetailReqVo reqVo) {
        List tpmAuditDetailEntities = this.tpmAuditDetailMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditDetailEntities)) {
            tpmAuditDetailEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmAuditDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmAuditDetailReqVo reqVo) {
        List tpmAuditDetailEntities = this.tpmAuditDetailMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditDetailEntities)) {
            tpmAuditDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAuditDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmAuditDetailReqVo reqVo) {
        List tpmAuditDetailEntities = this.tpmAuditDetailMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditDetailEntities)) {
            tpmAuditDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAuditDetailEntities);
    }
}

