/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.TpmAuditActMapper;
import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.audit.service.ITpmAuditActService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAuditActServiceExpandImpl"})
public class TpmAuditActServiceImpl
extends ServiceImpl<TpmAuditActMapper, TpmAuditActEntity>
implements ITpmAuditActService {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditActServiceImpl.class);
    @Resource
    private TpmAuditActMapper tpmAuditActMapper;

    @Override
    public PageResult<TpmAuditActRespVo> findList(TpmAuditActReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAuditActRespVo> list = this.tpmAuditActMapper.findList((Page<TpmAuditActRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAuditActRespVo query(TpmAuditActReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAuditActReqVo reqVo) {
        TpmAuditActEntity entity = (TpmAuditActEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditActEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAuditActReqVo reqVo) {
        TpmAuditActEntity entity = (TpmAuditActEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmAuditActReqVo reqVo) {
        List tpmAuditActEntities = this.tpmAuditActMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditActEntities)) {
            tpmAuditActEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmAuditActEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmAuditActReqVo reqVo) {
        List tpmAuditActEntities = this.tpmAuditActMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditActEntities)) {
            tpmAuditActEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAuditActEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmAuditActReqVo reqVo) {
        List tpmAuditActEntities = this.tpmAuditActMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditActEntities)) {
            tpmAuditActEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAuditActEntities);
    }
}

